/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;

public class KiePMMLModelWithSources
extends KiePMMLModel
implements HasSourcesMap {
    private static final long serialVersionUID = -7528313589316228283L;
    private final String kmodulePackageName;
    private final List<MiningField> miningFields;
    private final List<OutputField> outputFields;
    private final List<TargetField> targetFields;
    private final Map<String, String> sourcesMap;
    private final boolean isInterpreted;

    public KiePMMLModelWithSources(String fileName, String modelName, String kmodulePackageName, List<MiningField> miningFields, List<OutputField> outputFields, List<TargetField> targetFields, Map<String, String> sourcesMap, boolean isInterpreted) {
        super(fileName, modelName, Collections.emptyList());
        this.kmodulePackageName = kmodulePackageName;
        this.miningFields = miningFields;
        this.outputFields = outputFields;
        this.targetFields = targetFields;
        this.sourcesMap = sourcesMap;
        this.isInterpreted = isInterpreted;
    }

    @Override
    public Object evaluate(Map<String, Object> requestData, PMMLRuntimeContext context) {
        throw new KiePMMLException("KiePMMLModelWithSources is not meant to be used for actual evaluation");
    }

    @Override
    public List<MiningField> getMiningFields() {
        return this.miningFields;
    }

    @Override
    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public List<TargetField> getTargetFields() {
        return this.targetFields;
    }

    @Override
    public Map<String, String> getSourcesMap() {
        return Collections.unmodifiableMap(this.sourcesMap);
    }

    @Override
    public void addSourceMap(String key, String value) {
        this.sourcesMap.put(key, value);
    }

    @Override
    public String getKModulePackageName() {
        return this.kmodulePackageName;
    }

    @Override
    public boolean isInterpreted() {
        return this.isInterpreted;
    }
}

