/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;

public class KiePMMLTextIndexNormalization
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -1816258381871863674L;
    private KiePMMLInlineTable inlineTable;
    private String inField = "string";
    private String outField = "stem";
    private String regexField = "regex";
    private boolean recursive = false;
    private Boolean isCaseSensitive = null;
    private Integer maxLevenshteinDistance = null;
    private String wordSeparatorCharacterRE = null;
    private Boolean tokenize = null;

    private KiePMMLTextIndexNormalization(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    public String replace(String text, boolean isCaseSensitiveParam, int maxLevenshteinDistanceParam, boolean tokenizeParam, String wordSeparatorCharacterREParam) {
        Optional<String> retrieved = Optional.empty();
        if (this.inlineTable != null) {
            boolean replaced;
            AtomicReference<String> toEdit = new AtomicReference<String>(text);
            boolean isCaseSensitiveToUse = this.isCaseSensitive == null ? isCaseSensitiveParam : this.isCaseSensitive;
            int maxLevenshteinDistanceToUse = this.maxLevenshteinDistance == null ? maxLevenshteinDistanceParam : this.maxLevenshteinDistance;
            boolean tokenizeToUse = this.tokenize == null ? tokenizeParam : this.tokenize;
            String wordSeparatorCharacterREToUse = this.wordSeparatorCharacterRE == null ? wordSeparatorCharacterREParam : this.wordSeparatorCharacterRE;
            this.inlineTable.replace(toEdit, this.inField, this.outField, this.regexField, isCaseSensitiveToUse, maxLevenshteinDistanceToUse, tokenizeToUse, wordSeparatorCharacterREToUse);
            boolean bl = replaced = !text.equals(toEdit.get());
            if (this.recursive) {
                while (replaced) {
                    String original = toEdit.get();
                    this.inlineTable.replace(toEdit, this.inField, this.outField, this.regexField, isCaseSensitiveToUse, maxLevenshteinDistanceToUse, tokenizeToUse, wordSeparatorCharacterREToUse);
                    replaced = !original.equals(toEdit.get());
                }
            }
            retrieved = Optional.of(toEdit.get());
        }
        return retrieved.orElse(text);
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLTextIndexNormalization> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("TextIndexNormalization-", () -> new KiePMMLTextIndexNormalization(name, extensions));
        }

        public Builder withInField(String inField) {
            if (inField != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).inField = inField;
            }
            return this;
        }

        public Builder withOutField(String outField) {
            if (outField != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).outField = outField;
            }
            return this;
        }

        public Builder withKiePMMLInlineTable(KiePMMLInlineTable inlineTable) {
            if (inlineTable != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).inlineTable = inlineTable;
            }
            return this;
        }

        public Builder withRegexField(String regexField) {
            if (regexField != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).regexField = regexField;
            }
            return this;
        }

        public Builder withRecursive(boolean recursive) {
            ((KiePMMLTextIndexNormalization)this.toBuild).recursive = recursive;
            return this;
        }

        public Builder withIsCaseSensitive(Boolean isCaseSensitive) {
            if (isCaseSensitive != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).isCaseSensitive = isCaseSensitive;
            }
            return this;
        }

        public Builder withMaxLevenshteinDistance(Integer maxLevenshteinDistance) {
            if (maxLevenshteinDistance != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).maxLevenshteinDistance = maxLevenshteinDistance;
            }
            return this;
        }

        public Builder withWordSeparatorCharacterRE(String wordSeparatorCharacterRE) {
            if (wordSeparatorCharacterRE != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).wordSeparatorCharacterRE = wordSeparatorCharacterRE;
            }
            return this;
        }

        public Builder withTokenize(Boolean tokenize) {
            if (tokenize != null) {
                ((KiePMMLTextIndexNormalization)this.toBuild).tokenize = tokenize;
            }
            return this;
        }
    }
}

