/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db;

import java.util.Properties;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.kie.test.util.db.internal.DatabaseProvider;
import org.kie.test.util.db.internal.PoolingDataSourceWrapperImpl;

public final class DataSourceFactory {
    private DataSourceFactory() {
        throw new UnsupportedOperationException(DataSourceFactory.class.getSimpleName() + " should not be instantiated.");
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(String datasourceName, Properties driverProperties) {
        return DataSourceFactory.setupPoolingDataSource(datasourceName, driverProperties, new Properties());
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(String datasourceName, Properties driverProperties, Properties poolingProperties) {
        Properties sanitizedDriverProperties = new Properties();
        String driverClass = driverProperties.getProperty("driverClassName");
        DatabaseProvider databaseProvider = DatabaseProvider.fromDriverClassName(driverClass);
        for (String propertyName : new String[]{"user", "password"}) {
            sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
        }
        if (databaseProvider == DatabaseProvider.H2) {
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
        } else if (databaseProvider == DatabaseProvider.ORACLE) {
            sanitizedDriverProperties.put("driverType", "thin");
            sanitizedDriverProperties.put("URL", driverProperties.getProperty("url"));
        } else if (databaseProvider == DatabaseProvider.DB2) {
            for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
            sanitizedDriverProperties.put("driverType", "4");
            sanitizedDriverProperties.put("currentSchema", driverProperties.getProperty("defaultSchema"));
            sanitizedDriverProperties.put("ResultSetHoldability", "1");
            sanitizedDriverProperties.put("DowngradeHoldCursorsUnderXa", "true");
        } else if (databaseProvider == DatabaseProvider.MSSQL) {
            for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
            sanitizedDriverProperties.put("URL", driverProperties.getProperty("url"));
        } else if (databaseProvider == DatabaseProvider.MYSQL || databaseProvider == DatabaseProvider.MARIADB || databaseProvider == DatabaseProvider.SYBASE || databaseProvider == DatabaseProvider.POSTGRES || databaseProvider == DatabaseProvider.POSTGRES_PLUS) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName", "url"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
        } else {
            throw new RuntimeException("Unknown driver class: " + driverClass);
        }
        String xaDataSourceClassName = driverProperties.getProperty("className");
        return new PoolingDataSourceWrapperImpl(datasourceName, xaDataSourceClassName, sanitizedDriverProperties, poolingProperties);
    }
}

