/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.ws;

import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRemoteWsAuthenticator
extends Authenticator {
    protected static final Logger logger = LoggerFactory.getLogger(KieRemoteWsAuthenticator.class);
    private static ThreadLocal<PasswordAuthentication> threadLocalPasswordAuthentication = new ThreadLocal();
    private static KieRemoteWsAuthenticator _instance = new KieRemoteWsAuthenticator();
    private static AtomicBoolean authenticatorSet = new AtomicBoolean(false);

    public static KieRemoteWsAuthenticator getInstance() {
        return _instance;
    }

    private KieRemoteWsAuthenticator() {
        Authenticator.setDefault(this);
    }

    public void setUserAndPassword(String userName, String password) {
        KieRemoteWsAuthenticator.disableHttpUrlConnectionAuthCache();
        Authenticator.setDefault(_instance);
        PasswordAuthentication pwdAuth = threadLocalPasswordAuthentication.get();
        if (pwdAuth != null) {
            logger.debug("Replacing password authentication for user '{}' with new authentication for user '{}'", (Object)pwdAuth.getUserName(), (Object)userName);
        }
        pwdAuth = new PasswordAuthentication(userName, password.toCharArray());
        threadLocalPasswordAuthentication.set(pwdAuth);
    }

    public void clearUserAndPassword() {
        threadLocalPasswordAuthentication.set(null);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return threadLocalPasswordAuthentication.get();
    }

    public static void disableHttpUrlConnectionAuthCache() {
        if (!authenticatorSet.get() && authenticatorSet.compareAndSet(false, true)) {
            KieRemoteWsAuthenticator.insertFakeHashMapInAuthCache();
        }
    }

    private static void insertFakeHashMapInAuthCache() {
        try {
            Class<?> authCacheValueClass = Class.forName("sun.net.www.protocol.http.AuthCacheValue");
            Class<?> authCacheClass = Class.forName("sun.net.www.protocol.http.AuthCache");
            Class<?> authCacheImplClass = Class.forName("sun.net.www.protocol.http.AuthCacheImpl");
            Object cache = authCacheImplClass.newInstance();
            Method setMap = cache.getClass().getMethod("setMap", HashMap.class);
            setMap.invoke(cache, new HashMap(){

                @Override
                public Object put(Object key, Object value) {
                    return null;
                }
            });
            Method m = authCacheValueClass.getMethod("setAuthCache", authCacheClass);
            m.invoke(null, cache);
        }
        catch (Exception e) {
            logger.debug("Unable to disable AuthCache caching of HTTP authentication info", (Throwable)e);
        }
    }
}

