/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bleutrade.Bleutrade;
import org.knowm.xchange.bleutrade.BleutradeException;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalanceReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalancesReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeDepositAddressReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeWithdrawReturn;
import org.knowm.xchange.bleutrade.dto.trade.BleutradeCancelOrderReturn;
import org.knowm.xchange.bleutrade.dto.trade.BleutradeOpenOrdersReturn;
import org.knowm.xchange.bleutrade.dto.trade.BleutradePlaceOrderReturn;
import org.knowm.xchange.bleutrade.dto.trade.BluetradeExecutedTradesWrapper;
import org.knowm.xchange.bleutrade.service.BleutradeResponse;
import org.knowm.xchange.bleutrade.service.DepositRecord;
import org.knowm.xchange.bleutrade.service.WithdrawRecord;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v2")
@Produces(value={"application/json"})
public interface BleutradeAuthenticated
extends Bleutrade {
    @GET
    @Path(value="account/getdepositaddress")
    public BleutradeDepositAddressReturn getDepositAddress(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="currency") String var4) throws IOException, BleutradeException;

    @GET
    @Path(value="account/getbalance")
    public BleutradeBalanceReturn getBalance(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="currency") String var4) throws IOException, BleutradeException;

    @GET
    @Path(value="account/getbalances")
    public BleutradeBalancesReturn getBalances(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3) throws IOException, BleutradeException;

    @GET
    @Path(value="market/buylimit")
    public BleutradePlaceOrderReturn buyLimit(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="market") String var4, @QueryParam(value="quantity") String var5, @QueryParam(value="rate") String var6) throws IOException, BleutradeException;

    @GET
    @Path(value="market/selllimit")
    public BleutradePlaceOrderReturn sellLimit(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="market") String var4, @QueryParam(value="quantity") String var5, @QueryParam(value="rate") String var6) throws IOException, BleutradeException;

    @GET
    @Path(value="market/cancel")
    public BleutradeCancelOrderReturn cancel(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="orderid") String var4) throws IOException, BleutradeException;

    @GET
    @Path(value="market/getopenorders")
    public BleutradeOpenOrdersReturn getOrders(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3) throws IOException, BleutradeException;

    @GET
    @Path(value="account/getorders")
    public BluetradeExecutedTradesWrapper getTrades(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="market") String var4, @QueryParam(value="orderstatus") String var5, @QueryParam(value="ordertype") String var6) throws IOException, BleutradeException;

    @GET
    @Path(value="/account/withdraw")
    public BleutradeWithdrawReturn withdraw(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3, @QueryParam(value="currency") String var4, @QueryParam(value="quantity") BigDecimal var5, @QueryParam(value="address") String var6) throws IOException, BleutradeException;

    @GET
    @Path(value="/account/getdeposithistory")
    public BleutradeResponse<List<DepositRecord>> depositHistory(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3) throws IOException, BleutradeException;

    @GET
    @Path(value="/account/getwithdrawhistory")
    public BleutradeResponse<List<WithdrawRecord>> withdrawHistory(@QueryParam(value="apikey") String var1, @HeaderParam(value="apisign") ParamsDigest var2, @QueryParam(value="nonce") SynchronizedValueFactory<Long> var3) throws IOException, BleutradeException;
}

