/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bleutrade.BleutradeAdapters;
import org.knowm.xchange.bleutrade.dto.marketdata.BleutradeCurrency;
import org.knowm.xchange.bleutrade.dto.marketdata.BleutradeMarket;
import org.knowm.xchange.bleutrade.service.BleutradeAccountService;
import org.knowm.xchange.bleutrade.service.BleutradeMarketDataService;
import org.knowm.xchange.bleutrade.service.BleutradeMarketDataServiceRaw;
import org.knowm.xchange.bleutrade.service.BleutradeTradeService;
import org.knowm.xchange.utils.nonce.AtomicLongIncrementalTime2013NonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BleutradeExchange
extends BaseExchange
implements Exchange {
    private static SynchronizedValueFactory<Long> nonceFactory = new AtomicLongIncrementalTime2013NonceFactory();

    protected void initServices() {
        this.marketDataService = new BleutradeMarketDataService(this);
        this.accountService = new BleutradeAccountService(this);
        this.tradeService = new BleutradeTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://bleutrade.com/api/");
        exchangeSpecification.setHost("bleutrade.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Bleutrade");
        exchangeSpecification.setExchangeDescription("Bleutrade is a bitcoin and altcoin exchange.");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return nonceFactory;
    }

    public void remoteInit() throws IOException {
        List<BleutradeCurrency> currencies = ((BleutradeMarketDataServiceRaw)this.marketDataService).getBleutradeCurrencies();
        List<BleutradeMarket> markets = ((BleutradeMarketDataServiceRaw)this.marketDataService).getBleutradeMarkets();
        this.exchangeMetaData = BleutradeAdapters.adaptToExchangeMetaData(currencies, markets);
    }
}

