/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bleutrade.BleutradeAdapters;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalance;
import org.knowm.xchange.bleutrade.service.BleutradeAccountServiceRaw;
import org.knowm.xchange.bleutrade.service.DepositRecord;
import org.knowm.xchange.bleutrade.service.WithdrawRecord;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BleutradeAccountService
extends BleutradeAccountServiceRaw
implements AccountService {
    public BleutradeAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        List<BleutradeBalance> bleutradeBalances = this.getBleutradeBalances();
        return new AccountInfo(new Wallet[]{BleutradeAdapters.adaptBleutradeBalances(bleutradeBalances)});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdraw(currency, amount, address);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.getBleutradeDepositAddress(currency.toString()).getAddress();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            for (WithdrawRecord withdrawRecord : this.withdrawalHistory()) {
                String label = withdrawRecord.label;
                BigDecimal amount = withdrawRecord.amount;
                BigDecimal fee = null;
                String[] parts = label.split(";");
                String address = null;
                if (parts.length == 3) {
                    amount = new BigDecimal(parts[0]);
                    address = parts[1];
                    fee = new BigDecimal(parts[2]);
                }
                fundingRecords.add(new FundingRecord(address, dateFormat.parse(withdrawRecord.timestamp), Currency.getInstance((String)withdrawRecord.coin), amount, withdrawRecord.id, withdrawRecord.transactionId, FundingRecord.Type.WITHDRAWAL, FundingRecord.Status.COMPLETE, null, fee, label));
            }
            for (DepositRecord depositRecord : this.depositHistory()) {
                fundingRecords.add(new FundingRecord(null, dateFormat.parse(depositRecord.timestamp), Currency.getInstance((String)depositRecord.coin), depositRecord.amount, depositRecord.id, null, FundingRecord.Type.DEPOSIT, FundingRecord.Status.COMPLETE, null, null, depositRecord.label));
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("Should not happen", e);
        }
        return fundingRecords;
    }
}

