/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bleutrade.BleutradeException;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalance;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalanceReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeBalancesReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeDepositAddress;
import org.knowm.xchange.bleutrade.dto.account.BleutradeDepositAddressReturn;
import org.knowm.xchange.bleutrade.dto.account.BleutradeWithdrawReturn;
import org.knowm.xchange.bleutrade.service.BleutradeBaseService;
import org.knowm.xchange.bleutrade.service.BleutradeResponse;
import org.knowm.xchange.bleutrade.service.DepositRecord;
import org.knowm.xchange.bleutrade.service.WithdrawRecord;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class BleutradeAccountServiceRaw
extends BleutradeBaseService {
    public BleutradeAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String withdraw(Currency currency, BigDecimal amount, String address) throws IOException {
        BleutradeWithdrawReturn response = this.bleutrade.withdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency.getCurrencyCode(), amount, address);
        if (!response.success.booleanValue()) {
            throw new ExchangeException("Withdraw funds failed: " + response.toString());
        }
        return response.message;
    }

    public BleutradeDepositAddress getBleutradeDepositAddress(String currency) throws IOException {
        try {
            BleutradeDepositAddressReturn response = this.bleutrade.getDepositAddress(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency);
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public BleutradeBalance getBleutradeBalance(String currency) throws IOException {
        try {
            BleutradeBalanceReturn response = this.bleutrade.getBalance(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency);
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public List<BleutradeBalance> getBleutradeBalances() throws IOException {
        try {
            BleutradeBalancesReturn response = this.bleutrade.getBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public List<DepositRecord> depositHistory() throws IOException {
        BleutradeResponse<List<DepositRecord>> response = this.bleutrade.depositHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (!response.success) {
            throw new ExchangeException(response.message);
        }
        return (List)response.result;
    }

    public List<WithdrawRecord> withdrawalHistory() throws IOException {
        BleutradeResponse<List<WithdrawRecord>> response = this.bleutrade.withdrawHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (!response.success) {
            throw new ExchangeException(response.message);
        }
        return (List)response.result;
    }
}

