/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade.service;

import java.math.BigInteger;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BleutradeDigest
extends BaseParamsDigest {
    private BleutradeDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static BleutradeDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new BleutradeDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        String invocationUrl = restInvocation.getInvocationUrl();
        Mac mac = this.getMac();
        mac.update(invocationUrl.getBytes());
        return String.format("%0128x", new BigInteger(1, mac.doFinal()));
    }
}

