/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bleutrade.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bleutrade.BleutradeException;
import org.knowm.xchange.bleutrade.BleutradeUtils;
import org.knowm.xchange.bleutrade.dto.trade.BleutradeCancelOrderReturn;
import org.knowm.xchange.bleutrade.dto.trade.BleutradeOpenOrder;
import org.knowm.xchange.bleutrade.dto.trade.BleutradeOpenOrdersReturn;
import org.knowm.xchange.bleutrade.dto.trade.BleutradePlaceOrderReturn;
import org.knowm.xchange.bleutrade.dto.trade.BluetradeExecutedTrade;
import org.knowm.xchange.bleutrade.dto.trade.BluetradeExecutedTradesWrapper;
import org.knowm.xchange.bleutrade.service.BleutradeBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import si.mazi.rescu.SynchronizedValueFactory;

public class BleutradeTradeServiceRaw
extends BleutradeBaseService {
    public BleutradeTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String buyLimit(LimitOrder limitOrder) throws IOException {
        try {
            String pairString = BleutradeUtils.toPairString(limitOrder.getCurrencyPair());
            BleutradePlaceOrderReturn response = this.bleutrade.buyLimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pairString, limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult().getOrderid();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public String sellLimit(LimitOrder limitOrder) throws IOException {
        try {
            String pairString = BleutradeUtils.toPairString(limitOrder.getCurrencyPair());
            BleutradePlaceOrderReturn response = this.bleutrade.sellLimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pairString, limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString());
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult().getOrderid();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public boolean cancel(String orderId) throws IOException {
        try {
            BleutradeCancelOrderReturn response = this.bleutrade.cancel(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
            return response.getSuccess();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public List<BleutradeOpenOrder> getBleutradeOpenOrders() throws IOException {
        try {
            BleutradeOpenOrdersReturn response = this.bleutrade.getOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (!response.getSuccess().booleanValue()) {
                throw new ExchangeException(response.getMessage());
            }
            return response.getResult();
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public List<BluetradeExecutedTrade> getTrades(TradeHistoryParams params) throws IOException {
        CurrencyPair currencyPair;
        String market = null;
        String orderStatus = null;
        String orderType = null;
        if (params instanceof BleutradeTradeHistoryParams) {
            BleutradeTradeHistoryParams bleutradeTradeHistoryParams = (BleutradeTradeHistoryParams)params;
            market = bleutradeTradeHistoryParams.market;
            orderStatus = bleutradeTradeHistoryParams.orderStatus;
            orderType = bleutradeTradeHistoryParams.orderType;
        }
        if (params instanceof TradeHistoryParamCurrencyPair && (currencyPair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair()) != null) {
            market = BleutradeTradeServiceRaw.toMarket(currencyPair);
        }
        if (market == null) {
            market = BleutradeTradeHistoryParams.ALL.market;
        }
        if (orderStatus == null) {
            orderStatus = BleutradeTradeHistoryParams.ALL.orderStatus;
        }
        if (orderType == null) {
            orderType = BleutradeTradeHistoryParams.ALL.orderType;
        }
        try {
            BluetradeExecutedTradesWrapper response = this.bleutrade.getTrades(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), market, orderStatus, orderType);
            if (!response.success) {
                throw new ExchangeException(response.message);
            }
            return response.result;
        }
        catch (BleutradeException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    private static String toMarket(CurrencyPair currencyPair) {
        return currencyPair.base + "_" + currencyPair.counter;
    }

    public static class BleutradeTradeHistoryParams
    implements TradeHistoryParams {
        public static final BleutradeTradeHistoryParams ALL = new BleutradeTradeHistoryParams("ALL", "OK", "ALL");
        public final String market;
        public final String orderStatus;
        public final String orderType;

        public BleutradeTradeHistoryParams(CurrencyPair currencyPair, String orderStatus, String orderType) {
            this(BleutradeTradeServiceRaw.toMarket(currencyPair), orderStatus, orderType);
        }

        public BleutradeTradeHistoryParams(String market, String orderStatus, String orderType) {
            this.market = market;
            this.orderStatus = orderStatus;
            this.orderType = orderType;
        }
    }
}

