/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.campbx;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.campbx.dto.marketdata.CampBXOrderBook;
import org.knowm.xchange.campbx.dto.marketdata.CampBXTicker;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.trade.LimitOrder;

public final class CampBXAdapters {
    public static OrderBook adaptOrders(CampBXOrderBook orderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = CampBXAdapters.createOrders(currencyPair, Order.OrderType.ASK, orderBook.getAsks());
        List<LimitOrder> bids = CampBXAdapters.createOrders(currencyPair, Order.OrderType.BID, orderBook.getBids());
        return new OrderBook(null, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            CampBXAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(CampBXAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), currencyPair, "", null, priceAndAmount.get(0));
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Ticker adaptTicker(CampBXTicker campbxTicker, CurrencyPair currencyPair) {
        BigDecimal last = campbxTicker.getLast();
        BigDecimal bid = campbxTicker.getBid();
        BigDecimal ask = campbxTicker.getAsk();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).build();
    }
}

