/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.campbx.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.campbx.dto.CampBXResponse;
import org.knowm.xchange.campbx.dto.account.MyFunds;
import org.knowm.xchange.campbx.service.CampBXAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampBXAccountService
extends CampBXAccountServiceRaw
implements AccountService {
    private final Logger logger = LoggerFactory.getLogger(CampBXAccountService.class);

    public CampBXAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        MyFunds myFunds = this.getCampBXAccountInfo();
        this.logger.debug("myFunds = {}", (Object)myFunds);
        if (!myFunds.isError()) {
            return new AccountInfo(this.exchange.getExchangeSpecification().getUserName(), new Wallet[]{new Wallet(new Balance[]{new Balance(Currency.BTC, myFunds.getTotalBTC()), new Balance(Currency.USD, myFunds.getTotalUSD())})});
        }
        throw new ExchangeException("Error calling getAccountInfo(): " + myFunds.getError());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        CampBXResponse campBXResponse = this.withdrawCampBXFunds(amount, address);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.getSuccess();
        }
        throw new ExchangeException("Error calling withdrawFunds(): " + campBXResponse.getError());
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        CampBXResponse campBXResponse = this.requestCampBXBitcoinDepositAddress();
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.getSuccess();
        }
        throw new ExchangeException("Error calling requestBitcoinDepositAddress(): " + campBXResponse.getError());
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

