/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.campbx.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.campbx.CampBX;
import org.knowm.xchange.campbx.dto.CampBXOrder;
import org.knowm.xchange.campbx.dto.CampBXResponse;
import org.knowm.xchange.campbx.dto.trade.MyOpenOrders;
import org.knowm.xchange.campbx.service.CampBXTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampBXTradeService
extends CampBXTradeServiceRaw
implements TradeService {
    private final Logger logger = LoggerFactory.getLogger(CampBXTradeService.class);
    private static final MessageFormat ID_FORMAT = new MessageFormat("{0}-{1}");

    public CampBXTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        MyOpenOrders myOpenOrders = this.getCampBXOpenOrders();
        this.logger.debug("myOpenOrders = {}", (Object)myOpenOrders);
        if (!myOpenOrders.isError()) {
            BigDecimal price;
            String id;
            ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
            for (CampBXOrder cbo : myOpenOrders.getBuy()) {
                if (cbo.isError() || cbo.isInfo()) {
                    this.logger.debug("Skipping non-order in Buy: " + cbo);
                    continue;
                }
                id = this.composeOrderId(CampBX.OrderType.Buy, cbo.getOrderID());
                price = cbo.getPrice();
                orders.add(new LimitOrder(Order.OrderType.BID, cbo.getQuantity(), CurrencyPair.BTC_USD, id, cbo.getOrderEntered(), price));
            }
            for (CampBXOrder cbo : myOpenOrders.getSell()) {
                if (cbo.isError() || cbo.isInfo()) {
                    this.logger.debug("Skipping non-order in Sell: " + cbo);
                    continue;
                }
                id = this.composeOrderId(CampBX.OrderType.Sell, cbo.getOrderID());
                price = cbo.getPrice();
                orders.add(new LimitOrder(Order.OrderType.ASK, cbo.getQuantity(), CurrencyPair.BTC_USD, id, cbo.getOrderEntered(), price));
            }
            return new OpenOrders(orders);
        }
        throw new ExchangeException("Error calling getOpenOrders(): " + myOpenOrders.getError());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        CampBXResponse campBXResponse = this.placeCampBXMarketOrder(marketOrder);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return this.composeOrderId(campBXResponse.getSuccess(), marketOrder.getType());
        }
        throw new ExchangeException("Error calling placeMarketOrder(): " + campBXResponse.getError());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        CampBXResponse campBXResponse = this.placeCampBXLimitOrder(limitOrder);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return this.composeOrderId(campBXResponse.getSuccess(), limitOrder.getType());
        }
        throw new ExchangeException("Error calling placeLimitOrder(): " + campBXResponse.getError());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        CampBXResponse campBXResponse = this.cancelCampBXOrder(orderId);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.isSuccess();
        }
        throw new ExchangeException("Error calling cancelOrder(): " + campBXResponse.getError());
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    private String composeOrderId(String id, Order.OrderType orderType) {
        CampBX.OrderType type = orderType == Order.OrderType.ASK ? CampBX.OrderType.Sell : CampBX.OrderType.Buy;
        return this.composeOrderId(type, id);
    }

    private String composeOrderId(CampBX.OrderType type, String id) {
        return ID_FORMAT.format(new Object[]{type, id});
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

