/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAdapters;
import org.knowm.xchange.coinmate.dto.account.CoinmateDepositAddresses;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.service.CoinmateAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPagingSorted;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class CoinmateAccountService
extends CoinmateAccountServiceRaw
implements AccountService {
    public static final int DEFAULT_RESULT_LIMIT = 100;

    public CoinmateAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{CoinmateAdapters.adaptWallet(this.getCoinmateBalance())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateBitcoinWithdrawal(amount, address);
        return Long.toString((Long)response.getData());
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateBitcoinDepositAddresses();
        if (((ArrayList)addresses.getData()).isEmpty()) {
            return null;
        }
        return (String)((ArrayList)addresses.getData()).get(0);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new DefaultTradeHistoryParamPagingSorted(Integer.valueOf(100), TradeHistoryParamsSorted.Order.asc);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        DefaultTradeHistoryParamPagingSorted myParams = (DefaultTradeHistoryParamPagingSorted)params;
        return CoinmateAdapters.adaptFundingHistory(this.getCoinmateTransactionHistory(myParams.getPageNumber(), myParams.getPageLength(), CoinmateAdapters.adaptSortOrder(myParams.getOrder())));
    }
}

