/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.math.BigInteger;
import javax.crypto.Mac;
import javax.ws.rs.FormParam;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class CoinmateDigest
extends BaseParamsDigest {
    private final String clientId;
    private final String publicApiKey;

    private CoinmateDigest(String secretKeyBase64, String clientId, String publicApiKey) {
        super(secretKeyBase64, "HmacSHA256");
        this.clientId = clientId;
        this.publicApiKey = publicApiKey;
    }

    public static CoinmateDigest createInstance(String secretKeyBase64, String clientId, String publicApiKey) {
        return secretKeyBase64 == null ? null : new CoinmateDigest(secretKeyBase64, clientId, publicApiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        Mac mac256 = this.getMac();
        mac256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        mac256.update(this.clientId.getBytes());
        mac256.update(this.publicApiKey.getBytes());
        return String.format("%064x", new BigInteger(1, mac256.doFinal())).toUpperCase();
    }
}

