/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAdapters;
import org.knowm.xchange.coinmate.CoinmateUtils;
import org.knowm.xchange.coinmate.service.CoinmateMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CoinmateMarketDataService
extends CoinmateMarketDataServiceRaw
implements MarketDataService {
    private static final int TRANSACTIONS_MINUTES_INTO_HISTORY = 60;

    public CoinmateMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return CoinmateAdapters.adaptTicker(this.getCoinmateTicker(CoinmateUtils.getPair(currencyPair)), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        return CoinmateAdapters.adaptOrderBook(this.getCoinmateOrderBook(CoinmateUtils.getPair(currencyPair), true), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return CoinmateAdapters.adaptTrades(this.getCoinmateTransactions(60, CoinmateUtils.getPair(currencyPair)));
    }
}

