/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAdapters;
import org.knowm.xchange.coinmate.CoinmateException;
import org.knowm.xchange.coinmate.CoinmateUtils;
import org.knowm.xchange.coinmate.dto.trade.CoinmateCancelOrderResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrders;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.service.CoinmateOpenOrdersParams;
import org.knowm.xchange.coinmate.service.CoinmateTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPagingSorted;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class CoinmateTradeService
extends CoinmateTradeServiceRaw
implements TradeService {
    public CoinmateTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders((OpenOrdersParams)this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        CurrencyPair currencyPair = null;
        if (params instanceof OpenOrdersParamCurrencyPair) {
            currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        }
        String currencyPairString = CoinmateUtils.getPair(currencyPair);
        CoinmateOpenOrders coinmateOpenOrders = this.getCoinmateOpenOrders(currencyPairString);
        List<LimitOrder> orders = CoinmateAdapters.adaptOpenOrders(coinmateOpenOrders);
        return new OpenOrders(orders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        CoinmateTradeResponse response;
        if (marketOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.sellCoinmateInstant(marketOrder.getOriginalAmount(), CoinmateUtils.getPair(marketOrder.getCurrencyPair()));
        } else if (marketOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.buyCoinmateInstant(marketOrder.getOriginalAmount(), CoinmateUtils.getPair(marketOrder.getCurrencyPair()));
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString((Long)response.getData());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        CoinmateTradeResponse response;
        if (limitOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.sellCoinmateLimit(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()));
        } else if (limitOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.buyCoinmateLimit(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()));
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString((Long)response.getData());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        CoinmateCancelOrderResponse response = this.cancelCoinmateOrder(orderId);
        return (Boolean)response.getData();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        DefaultTradeHistoryParamPagingSorted myParams = (DefaultTradeHistoryParamPagingSorted)params;
        return CoinmateAdapters.adaptTransactionHistory(this.getCoinmateTradeHistory(myParams.getPageNumber(), myParams.getPageLength(), CoinmateAdapters.adaptSortOrder(myParams.getOrder())));
    }

    public TradeHistoryParams createTradeHistoryParams() {
        DefaultTradeHistoryParamPagingSorted params = new DefaultTradeHistoryParamPagingSorted(Integer.valueOf(100));
        params.setPageNumber(Integer.valueOf(0));
        params.setOrder(TradeHistoryParamsSorted.Order.asc);
        return params;
    }

    public CoinmateOpenOrdersParams createOpenOrdersParams() {
        return new CoinmateOpenOrdersParams();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

