/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAuthenticated;
import org.knowm.xchange.coinmate.dto.trade.CoinmateCancelOrderResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateCancelOrderWithInfoResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrders;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOrderHistory;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistory;
import org.knowm.xchange.coinmate.service.CoinmateBaseService;
import org.knowm.xchange.coinmate.service.CoinmateDigest;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class CoinmateTradeServiceRaw
extends CoinmateBaseService {
    private final CoinmateDigest signatureCreator;
    private final CoinmateAuthenticated coinmateAuthenticated;

    public CoinmateTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.coinmateAuthenticated = (CoinmateAuthenticated)RestProxyFactory.createProxy(CoinmateAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.signatureCreator = CoinmateDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), exchange.getExchangeSpecification().getApiKey());
    }

    public CoinmateTransactionHistory getCoinmateTradeHistory(int offset, int limit, String sort) throws IOException {
        CoinmateTransactionHistory tradeHistory = this.coinmateAuthenticated.getTransactionHistory(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), offset, limit, sort);
        CoinmateTradeServiceRaw.throwExceptionIfError(tradeHistory);
        return tradeHistory;
    }

    public CoinmateOrderHistory getCoinmateOrderHistory(String currencyPair, int limit) throws IOException {
        CoinmateOrderHistory orderHistory = this.coinmateAuthenticated.getOrderHistory(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currencyPair, limit);
        CoinmateTradeServiceRaw.throwExceptionIfError(orderHistory);
        return orderHistory;
    }

    public CoinmateOpenOrders getCoinmateOpenOrders(String currencyPair) throws IOException {
        CoinmateOpenOrders openOrders = this.coinmateAuthenticated.getOpenOrders(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currencyPair);
        CoinmateTradeServiceRaw.throwExceptionIfError(openOrders);
        return openOrders;
    }

    public CoinmateCancelOrderResponse cancelCoinmateOrder(String orderId) throws IOException {
        CoinmateCancelOrderResponse response = this.coinmateAuthenticated.cancelOder(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateCancelOrderWithInfoResponse cancelCoinmateOrderWithInfo(String orderId) throws IOException {
        CoinmateCancelOrderWithInfoResponse response = this.coinmateAuthenticated.cancelOderWithInfo(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateTradeResponse buyCoinmateLimit(BigDecimal amount, BigDecimal price, String currencyPair) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.buyLimit(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, price, currencyPair);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateTradeResponse sellCoinmateLimit(BigDecimal amount, BigDecimal price, String currencyPair) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.sellLimit(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, price, currencyPair);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateTradeResponse buyCoinmateInstant(BigDecimal total, String currencyPair) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.buyInstant(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), total, currencyPair);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateTradeResponse sellCoinmateInstant(BigDecimal total, String currencyPair) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.sellInstant(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), total, currencyPair);
        CoinmateTradeServiceRaw.throwExceptionIfError(response);
        return response;
    }
}

