/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.account.KrakenDepositAddress;
import org.knowm.xchange.kraken.dto.account.KrakenLedger;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAsset;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssetPair;
import org.knowm.xchange.kraken.dto.marketdata.KrakenDepth;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicOrder;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicTrade;
import org.knowm.xchange.kraken.dto.marketdata.KrakenTicker;
import org.knowm.xchange.kraken.dto.trade.KrakenOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderDescription;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderResponse;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderStatus;
import org.knowm.xchange.kraken.dto.trade.KrakenTrade;
import org.knowm.xchange.kraken.dto.trade.KrakenType;
import org.knowm.xchange.kraken.dto.trade.KrakenUserTrade;

public class KrakenAdapters {
    public static OrderBook adaptOrderBook(KrakenDepth krakenDepth, CurrencyPair currencyPair) {
        OrdersContainer asksOrdersContainer = KrakenAdapters.adaptOrders(krakenDepth.getAsks(), currencyPair, Order.OrderType.ASK);
        OrdersContainer bidsOrdersContainer = KrakenAdapters.adaptOrders(krakenDepth.getBids(), currencyPair, Order.OrderType.BID);
        return new OrderBook(new Date(Math.max(asksOrdersContainer.getTimestamp(), bidsOrdersContainer.getTimestamp())), asksOrdersContainer.getLimitOrders(), bidsOrdersContainer.getLimitOrders());
    }

    public static OrdersContainer adaptOrders(List<KrakenPublicOrder> orders, CurrencyPair currencyPair, Order.OrderType orderType) {
        long maxTimestamp = -9223372036854775807L;
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.size());
        for (KrakenPublicOrder order : orders) {
            if (order.getTimestamp() > maxTimestamp) {
                maxTimestamp = order.getTimestamp();
            }
            limitOrders.add(KrakenAdapters.adaptOrder(order, orderType, currencyPair));
        }
        return new OrdersContainer(maxTimestamp * 1000L, limitOrders);
    }

    public static LimitOrder adaptOrder(KrakenPublicOrder order, Order.OrderType orderType, CurrencyPair currencyPair) {
        Date timeStamp = new Date(order.getTimestamp() * 1000L);
        BigDecimal volume = order.getVolume();
        return new LimitOrder(orderType, volume, currencyPair, "", timeStamp, order.getPrice());
    }

    public static Ticker adaptTicker(KrakenTicker krakenTicker, CurrencyPair currencyPair) {
        Ticker.Builder builder = new Ticker.Builder();
        builder.ask(krakenTicker.getAsk().getPrice());
        builder.bid(krakenTicker.getBid().getPrice());
        builder.last(krakenTicker.getClose().getPrice());
        builder.high(krakenTicker.get24HourHigh());
        builder.low(krakenTicker.get24HourLow());
        builder.vwap(krakenTicker.get24HourVolumeAvg());
        builder.volume(krakenTicker.get24HourVolume());
        builder.currencyPair(currencyPair);
        return builder.build();
    }

    public static Trades adaptTrades(List<KrakenPublicTrade> krakenTrades, CurrencyPair currencyPair, long last) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (KrakenPublicTrade krakenTrade : krakenTrades) {
            trades.add(KrakenAdapters.adaptTrade(krakenTrade, currencyPair));
        }
        return new Trades(trades, last, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptTrade(KrakenPublicTrade krakenPublicTrade, CurrencyPair currencyPair) {
        Order.OrderType type = KrakenAdapters.adaptOrderType(krakenPublicTrade.getType());
        BigDecimal originalAmount = krakenPublicTrade.getVolume();
        Date timestamp = new Date((long)(krakenPublicTrade.getTime() * 1000.0));
        return new Trade(type, originalAmount, currencyPair, krakenPublicTrade.getPrice(), timestamp, String.valueOf((long)(krakenPublicTrade.getTime() * 10000.0)));
    }

    public static Wallet adaptWallet(Map<String, BigDecimal> krakenWallet) {
        ArrayList<Balance> balances = new ArrayList<Balance>(krakenWallet.size());
        for (Map.Entry<String, BigDecimal> balancePair : krakenWallet.entrySet()) {
            Currency currency = KrakenAdapters.adaptCurrency(balancePair.getKey());
            Balance balance = new Balance(currency, balancePair.getValue());
            balances.add(balance);
        }
        return new Wallet(balances);
    }

    public static Set<CurrencyPair> adaptCurrencyPairs(Collection<String> krakenCurrencyPairs) {
        HashSet<CurrencyPair> currencyPairs = new HashSet<CurrencyPair>();
        for (String krakenCurrencyPair : krakenCurrencyPairs) {
            CurrencyPair currencyPair = KrakenAdapters.adaptCurrencyPair(krakenCurrencyPair);
            if (currencyPair == null) continue;
            currencyPairs.add(currencyPair);
        }
        return currencyPairs;
    }

    public static Currency adaptCurrency(String krakenCurrencyCode) {
        return KrakenUtils.translateKrakenCurrencyCode(krakenCurrencyCode);
    }

    public static CurrencyPair adaptCurrencyPair(String krakenCurrencyPair) {
        return KrakenUtils.translateKrakenCurrencyPair(krakenCurrencyPair);
    }

    public static OpenOrders adaptOpenOrders(Map<String, KrakenOrder> krakenOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (Map.Entry<String, KrakenOrder> krakenOrderEntry : krakenOrders.entrySet()) {
            KrakenOrder krakenOrder = krakenOrderEntry.getValue();
            KrakenOrderDescription orderDescription = krakenOrder.getOrderDescription();
            if (!"limit".equals(orderDescription.getOrderType().toString())) continue;
            limitOrders.add(KrakenAdapters.adaptLimitOrder(krakenOrder, krakenOrderEntry.getKey()));
        }
        return new OpenOrders(limitOrders);
    }

    public static LimitOrder adaptLimitOrder(KrakenOrder krakenOrder, String id) {
        KrakenOrderDescription orderDescription = krakenOrder.getOrderDescription();
        Order.OrderType type = KrakenAdapters.adaptOrderType(orderDescription.getType());
        BigDecimal originalAmount = krakenOrder.getVolume();
        BigDecimal filledAmount = krakenOrder.getVolumeExecuted();
        BigDecimal remainingAmount = originalAmount.min(filledAmount);
        CurrencyPair pair = KrakenAdapters.adaptCurrencyPair(orderDescription.getAssetPair());
        Date timestamp = new Date((long)(krakenOrder.getOpenTimestamp() * 1000.0));
        Order.OrderStatus status = KrakenAdapters.adaptOrderStatus(krakenOrder.getStatus());
        if (status == Order.OrderStatus.NEW && filledAmount.compareTo(BigDecimal.ZERO) > 0 && filledAmount.compareTo(originalAmount) < 0) {
            status = Order.OrderStatus.PARTIALLY_FILLED;
        }
        return new LimitOrder(type, originalAmount, pair, id, timestamp, orderDescription.getPrice(), orderDescription.getPrice(), filledAmount, status);
    }

    public static UserTrades adaptTradesHistory(Map<String, KrakenTrade> krakenTrades) {
        ArrayList<KrakenUserTrade> trades = new ArrayList<KrakenUserTrade>();
        for (Map.Entry<String, KrakenTrade> krakenTradeEntry : krakenTrades.entrySet()) {
            trades.add(KrakenAdapters.adaptTrade(krakenTradeEntry.getValue(), krakenTradeEntry.getKey()));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByID);
    }

    public static KrakenUserTrade adaptTrade(KrakenTrade krakenTrade, String tradeId) {
        Order.OrderType orderType = KrakenAdapters.adaptOrderType(krakenTrade.getType());
        BigDecimal originalAmount = krakenTrade.getVolume();
        String krakenAssetPair = krakenTrade.getAssetPair();
        CurrencyPair pair = KrakenAdapters.adaptCurrencyPair(krakenAssetPair);
        Date timestamp = new Date((long)(krakenTrade.getUnixTimestamp() * 1000.0));
        BigDecimal averagePrice = krakenTrade.getAverageClosePrice();
        BigDecimal price = averagePrice == null ? krakenTrade.getPrice() : averagePrice;
        return new KrakenUserTrade(orderType, originalAmount, pair, price, timestamp, tradeId, krakenTrade.getOrderTxId(), krakenTrade.getFee(), pair.counter, krakenTrade.getCost());
    }

    public static Order.OrderType adaptOrderType(KrakenType krakenType) {
        return krakenType.equals((Object)KrakenType.BUY) ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static String adaptKrakenDepositAddress(KrakenDepositAddress[] krakenDepositAddress) {
        return krakenDepositAddress[0].getAddress();
    }

    public static String adaptOrderId(KrakenOrderResponse orderResponse) {
        List<String> orderIds = orderResponse.getTransactionIds();
        return orderIds == null || orderIds.isEmpty() ? "" : orderIds.get(0);
    }

    public static ExchangeMetaData adaptToExchangeMetaData(ExchangeMetaData originalMetaData, Map<String, KrakenAssetPair> krakenPairs, Map<String, KrakenAsset> krakenAssets) {
        HashMap<CurrencyPair, CurrencyPairMetaData> pairs = new HashMap<CurrencyPair, CurrencyPairMetaData>();
        KrakenUtils.setKrakenAssets(krakenAssets);
        KrakenUtils.setKrakenAssetPairs(krakenPairs);
        pairs.putAll(originalMetaData.getCurrencyPairs());
        for (String krakenPairCode : krakenPairs.keySet()) {
            if (krakenPairCode.endsWith(".d")) continue;
            KrakenAssetPair krakenPair = krakenPairs.get(krakenPairCode);
            pairs.put(KrakenAdapters.adaptCurrencyPair(krakenPairCode), KrakenAdapters.adaptPair(krakenPair, (CurrencyPairMetaData)pairs.get(KrakenAdapters.adaptCurrencyPair(krakenPairCode))));
        }
        HashMap<Currency, CurrencyMetaData> currencies = new HashMap<Currency, CurrencyMetaData>();
        currencies.putAll(originalMetaData.getCurrencies());
        for (String krakenAssetCode : krakenAssets.keySet()) {
            KrakenAsset krakenAsset = krakenAssets.get(krakenAssetCode);
            Currency currencyCode = KrakenAdapters.adaptCurrency(krakenAssetCode);
            currencies.put(currencyCode, new CurrencyMetaData(krakenAsset.getScale()));
        }
        return new ExchangeMetaData(pairs, currencies, originalMetaData == null ? null : originalMetaData.getPublicRateLimits(), originalMetaData == null ? null : originalMetaData.getPrivateRateLimits(), originalMetaData == null ? null : Boolean.valueOf(originalMetaData.isShareRateLimits()));
    }

    private static CurrencyPairMetaData adaptPair(KrakenAssetPair krakenPair, CurrencyPairMetaData OriginalMeta) {
        if (OriginalMeta != null) {
            return new CurrencyPairMetaData(krakenPair.getFees().get(0).getPercentFee().divide(new BigDecimal(100)), OriginalMeta.getMinimumAmount(), OriginalMeta.getMaximumAmount(), Integer.valueOf(krakenPair.getPairScale()));
        }
        return new CurrencyPairMetaData(krakenPair.getFees().get(0).getPercentFee().divide(new BigDecimal(100)), null, null, Integer.valueOf(krakenPair.getPairScale()));
    }

    public static List<FundingRecord> adaptFundingHistory(Map<String, KrakenLedger> krakenLedgerInfo) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (Map.Entry<String, KrakenLedger> ledgerEntry : krakenLedgerInfo.entrySet()) {
            Currency currency;
            KrakenLedger krakenLedger = ledgerEntry.getValue();
            if (krakenLedger.getLedgerType() == null || (currency = KrakenAdapters.adaptCurrency(krakenLedger.getAsset())) == null) continue;
            Date timestamp = new Date((long)(krakenLedger.getUnixTime() * 1000.0));
            FundingRecord.Type type = FundingRecord.Type.fromString((String)krakenLedger.getLedgerType().name());
            if (type == null) continue;
            String internalId = krakenLedger.getRefId();
            FundingRecord fundingRecordEntry = new FundingRecord(null, timestamp, currency, krakenLedger.getTransactionAmount(), internalId, null, FundingRecord.Type.fromString((String)krakenLedger.getLedgerType().name()), FundingRecord.Status.COMPLETE, krakenLedger.getBalance(), krakenLedger.getFee(), null);
            fundingRecords.add(fundingRecordEntry);
        }
        return fundingRecords;
    }

    public static Order.OrderStatus adaptOrderStatus(KrakenOrderStatus status) {
        switch (status) {
            case PENDING: {
                return Order.OrderStatus.PENDING_NEW;
            }
            case OPEN: {
                return Order.OrderStatus.NEW;
            }
            case CLOSED: {
                return Order.OrderStatus.FILLED;
            }
            case CANCELED: {
                return Order.OrderStatus.CANCELED;
            }
            case EXPIRED: {
                return Order.OrderStatus.EXPIRED;
            }
        }
        return null;
    }

    public static class OrdersContainer {
        private final long timestamp;
        private final List<LimitOrder> limitOrders;

        public OrdersContainer(long timestamp, List<LimitOrder> limitOrders) {
            this.timestamp = timestamp;
            this.limitOrders = limitOrders;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<LimitOrder> getLimitOrders() {
            return this.limitOrders;
        }
    }
}

