/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.trade;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderType;
import org.knowm.xchange.kraken.dto.trade.KrakenType;

public class KrakenStandardOrder {
    private final CurrencyPair currencyPair;
    private final KrakenType type;
    private final KrakenOrderType orderType;
    private final String price;
    private final String secondaryPrice;
    private final BigDecimal volume;
    private final String leverage;
    private final String positionTxId;
    private final Set<Order.IOrderFlags> orderFlags;
    private final String startTime;
    private final String expireTime;
    private final String userRefId;
    private final boolean validateOnly;
    private final Map<String, String> closeOrder;

    private KrakenStandardOrder(CurrencyPair currencyPair, KrakenType type, KrakenOrderType orderType, String price, String secondaryPrice, BigDecimal volume, String leverage, String positionTxId, Set<Order.IOrderFlags> orderFlags, String startTime, String expireTime, String userRefId, boolean validateOnly, Map<String, String> closeOrder) {
        this.currencyPair = currencyPair;
        this.type = type;
        this.orderType = orderType;
        this.price = price;
        this.secondaryPrice = secondaryPrice;
        this.volume = volume;
        this.leverage = leverage;
        this.positionTxId = positionTxId;
        this.orderFlags = orderFlags;
        this.startTime = startTime;
        this.expireTime = expireTime;
        this.userRefId = userRefId;
        this.validateOnly = validateOnly;
        this.closeOrder = closeOrder;
    }

    public CurrencyPair getAssetPair() {
        return this.currencyPair;
    }

    public KrakenType getType() {
        return this.type;
    }

    public KrakenOrderType getOrderType() {
        return this.orderType;
    }

    public String getPrice() {
        return this.price;
    }

    public String getSecondaryPrice() {
        return this.secondaryPrice;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public String getPositionTxId() {
        return this.positionTxId;
    }

    public Set<Order.IOrderFlags> getOrderFlags() {
        return this.orderFlags;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public String getUserRefId() {
        return this.userRefId;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public Map<String, String> getCloseOrder() {
        return this.closeOrder;
    }

    public String toString() {
        return "KrakenStandardOrder [currencyPair=" + this.currencyPair + ", type=" + (Object)((Object)this.type) + ", orderType=" + (Object)((Object)this.orderType) + ", price=" + this.price + ", secondaryPrice=" + this.secondaryPrice + ", volume=" + this.volume + ", leverage=" + this.leverage + ", positionTxId=" + this.positionTxId + ", orderFlags=" + this.orderFlags + ", startTime=" + this.startTime + ", expireTime=" + this.expireTime + ", userRefId=" + this.userRefId + ", validateOnly=" + this.validateOnly + ", closeOrder=" + this.closeOrder + "]";
    }

    public static KrakenOrderBuilder getMarketOrderBuilder(CurrencyPair currencyPair, KrakenType type, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.MARKET, volume);
    }

    public static KrakenOrderBuilder getLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String limitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.LIMIT, volume).withPrice(limitPrice);
    }

    public static KrakenOrderBuilder getStopLossOrderBuilder(CurrencyPair currencyPair, KrakenType type, String stopLossPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.STOP_LOSS, volume).withPrice(stopLossPrice);
    }

    public static KrakenOrderBuilder getTakeProfitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String takeProfitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.TAKE_PROFIT, volume).withPrice(takeProfitPrice);
    }

    public static KrakenOrderBuilder getStopLossProfitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String stopLossPrice, String takeProfitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.STOP_LOSS_PROFIT, volume).withPrice(stopLossPrice).withSecondaryPrice(takeProfitPrice);
    }

    public static KrakenOrderBuilder getStopLossProfitLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String stopLossPrice, String takeProfitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.STOP_LOSS_PROFIT_LIMIT, volume).withPrice(stopLossPrice).withSecondaryPrice(takeProfitPrice);
    }

    public static KrakenOrderBuilder getStopLossLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String stopLossTriggerPrice, String triggeredLimitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.STOP_LOSS_LIMIT, volume).withPrice(stopLossTriggerPrice).withSecondaryPrice(triggeredLimitPrice);
    }

    public static KrakenOrderBuilder getTakeProfitLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String takeProfitTriggerPrice, String triggeredLimitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.TAKE_PROFIT_LIMIT, volume).withPrice(takeProfitTriggerPrice).withSecondaryPrice(triggeredLimitPrice);
    }

    public static KrakenOrderBuilder getTrailingStopOrderBuilder(CurrencyPair currencyPair, KrakenType type, String trailingStopOffset, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.TRAILING_STOP, volume).withPrice(trailingStopOffset);
    }

    public static KrakenOrderBuilder getTrailingStopLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String trailingStopOffset, String triggeredLimitOffset, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.TRAILING_STOP_LIMIT, volume).withPrice(trailingStopOffset).withSecondaryPrice(triggeredLimitOffset);
    }

    public static KrakenOrderBuilder getStopLossAndLimitOrderBuilder(CurrencyPair currencyPair, KrakenType type, String stopLossPrice, String limitPrice, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.STOP_LOSS_AND_LIMIT, volume).withPrice(stopLossPrice).withSecondaryPrice(limitPrice);
    }

    public static KrakenOrderBuilder getSettlePositionOrderBuilder(CurrencyPair currencyPair, KrakenType type, BigDecimal volume) {
        return new KrakenOrderBuilder(currencyPair, type, KrakenOrderType.SETTLE_POSITION, volume).withLeverage("2");
    }

    public static class KrakenOrderBuilder {
        private final CurrencyPair currencyPair;
        private final KrakenType type;
        private final KrakenOrderType orderType;
        private String price;
        private String secondaryPrice;
        private final BigDecimal volume;
        private String leverage;
        private String positionTxId;
        private final Set<Order.IOrderFlags> orderFlags;
        private String startTime;
        private String expireTime;
        private String userRefId;
        private boolean validateOnly;
        private Map<String, String> closeOrder;

        private KrakenOrderBuilder(CurrencyPair currencyPair, KrakenType type, KrakenOrderType orderType, BigDecimal volume) {
            this.currencyPair = currencyPair;
            this.type = type;
            this.orderType = orderType;
            this.volume = volume;
            this.orderFlags = new HashSet<Order.IOrderFlags>();
            this.startTime = "0";
            this.positionTxId = "0";
            this.validateOnly = false;
        }

        public KrakenOrderBuilder withPrice(String price) {
            this.price = price;
            return this;
        }

        public KrakenOrderBuilder withSecondaryPrice(String secondaryPrice) {
            this.secondaryPrice = secondaryPrice;
            return this;
        }

        public KrakenOrderBuilder withLeverage(String leverage) {
            this.leverage = leverage;
            return this;
        }

        public KrakenOrderBuilder withPositionTxId(String positionTxId) {
            this.positionTxId = positionTxId;
            return this;
        }

        public KrakenOrderBuilder withOrderFlags(Set<Order.IOrderFlags> flags) {
            if (flags == null) {
                this.orderFlags.clear();
            } else {
                this.orderFlags.addAll(flags);
            }
            return this;
        }

        public KrakenOrderBuilder withStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public KrakenOrderBuilder withExpireTime(String expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public KrakenOrderBuilder withUserRefId(String userRefId) {
            this.userRefId = userRefId;
            return this;
        }

        public KrakenOrderBuilder withValidateOnly(boolean validateOnly) {
            this.validateOnly = validateOnly;
            return this;
        }

        public KrakenOrderBuilder withCloseOrder(KrakenOrderType orderType, String price, String secondaryPrice) {
            this.closeOrder = new HashMap<String, String>();
            this.closeOrder.put("ordertype", orderType.toString());
            this.closeOrder.put("price", price);
            this.closeOrder.put("price2", secondaryPrice);
            return this;
        }

        public KrakenStandardOrder buildOrder() {
            return new KrakenStandardOrder(this.currencyPair, this.type, this.orderType, this.price, this.secondaryPrice, this.volume, this.leverage, this.positionTxId, this.orderFlags, this.startTime, this.expireTime, this.userRefId, this.validateOnly, this.closeOrder);
        }

        public String toString() {
            return "KrakenOrderBuilder [currencyPair=" + this.currencyPair + ", type=" + (Object)((Object)this.type) + ", orderType=" + (Object)((Object)this.orderType) + ", price=" + this.price + ", secondaryPrice=" + this.secondaryPrice + ", volume=" + this.volume + ", leverage=" + this.leverage + ", positionTxId=" + this.positionTxId + ", orderFlags=" + this.orderFlags + ", startTime=" + this.startTime + ", expireTime=" + this.expireTime + ", userRefId=" + this.userRefId + ", validateOnly=" + this.validateOnly + ", closeOrder=" + this.closeOrder + "]";
        }

        public CurrencyPair getAssetPair() {
            return this.currencyPair;
        }

        public KrakenType getType() {
            return this.type;
        }

        public KrakenOrderType getOrderType() {
            return this.orderType;
        }

        public String getPrice() {
            return this.price;
        }

        public String getSecondaryPrice() {
            return this.secondaryPrice;
        }

        public BigDecimal getVolume() {
            return this.volume;
        }

        public String getLeverage() {
            return this.leverage;
        }

        public String getPositionTxId() {
            return this.positionTxId;
        }

        public Set<Order.IOrderFlags> getOrderFlags() {
            return this.orderFlags;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getExpireTime() {
            return this.expireTime;
        }

        public String getUserRefId() {
            return this.userRefId;
        }

        public boolean isValidateOnly() {
            return this.validateOnly;
        }

        public Map<String, String> getCloseOrder() {
            return this.closeOrder;
        }
    }
}

