/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.account.KrakenTradeVolume;
import org.knowm.xchange.kraken.dto.account.results.KrakenTradeVolumeResult;
import org.knowm.xchange.kraken.dto.trade.KrakenOpenPosition;
import org.knowm.xchange.kraken.dto.trade.KrakenOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderResponse;
import org.knowm.xchange.kraken.dto.trade.KrakenStandardOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenTrade;
import org.knowm.xchange.kraken.dto.trade.KrakenType;
import org.knowm.xchange.kraken.dto.trade.results.KrakenCancelOrderResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenClosedOrdersResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenOpenOrdersResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenOpenPositionsResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenOrderResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenQueryOrderResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenQueryTradeResult;
import org.knowm.xchange.kraken.dto.trade.results.KrakenTradeHistoryResult;
import org.knowm.xchange.kraken.service.KrakenBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class KrakenTradeServiceRaw
extends KrakenBaseService {
    public KrakenTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, KrakenOrder> getKrakenOpenOrders() throws IOException {
        return this.getKrakenOpenOrders(false, null);
    }

    public Map<String, KrakenOrder> getKrakenOpenOrders(boolean includeTrades, String userRef) throws IOException {
        KrakenOpenOrdersResult result = this.kraken.openOrders(includeTrades, userRef, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result).getOrders();
    }

    public Map<String, KrakenOrder> getKrakenClosedOrders() throws IOException {
        return this.getKrakenClosedOrders(false, null, null, null, null, null);
    }

    public Map<String, KrakenOrder> getKrakenClosedOrders(boolean includeTrades, String userRef, String start, String end, String offset, String closeTime) throws IOException {
        KrakenClosedOrdersResult result = this.kraken.closedOrders(includeTrades, userRef, start, end, offset, closeTime, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result).getOrders();
    }

    public Map<String, KrakenOrder> queryKrakenOrders(String ... transactionIds) throws IOException {
        return this.queryKrakenOrders(false, null, transactionIds);
    }

    public KrakenQueryOrderResult queryKrakenOrdersResult(boolean includeTrades, String userRef, String ... transactionIds) throws IOException {
        KrakenQueryOrderResult krakenQueryOrderResult = this.kraken.queryOrders(includeTrades, userRef, this.createDelimitedString(transactionIds), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return krakenQueryOrderResult;
    }

    public Map<String, KrakenOrder> queryKrakenOrders(boolean includeTrades, String userRef, String ... transactionIds) throws IOException {
        KrakenQueryOrderResult result = this.kraken.queryOrders(includeTrades, userRef, this.createDelimitedString(transactionIds), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public Map<String, KrakenTrade> getKrakenTradeHistory() throws IOException {
        return this.getKrakenTradeHistory(null, false, null, null, null);
    }

    public Map<String, KrakenTrade> getKrakenTradeHistory(String type, boolean includeTrades, Long start, Long end, Long offset) throws IOException {
        KrakenTradeHistoryResult result = this.kraken.tradeHistory(type, includeTrades, start, end, offset, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result).getTrades();
    }

    public Map<String, KrakenTrade> queryKrakenTrades(String ... transactionIds) throws IOException {
        return this.queryKrakenTrades(false, transactionIds);
    }

    public Map<String, KrakenTrade> queryKrakenTrades(boolean includeTrades, String ... transactionIds) throws IOException {
        KrakenQueryTradeResult result = this.kraken.queryTrades(includeTrades, this.createDelimitedString(transactionIds), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public Map<String, KrakenOpenPosition> getOpenPositions() throws IOException {
        return this.getOpenPositions(false, new String[0]);
    }

    public Map<String, KrakenOpenPosition> getOpenPositions(boolean doCalcs, String ... transactionIds) throws IOException {
        KrakenOpenPositionsResult result = this.kraken.openPositions(this.createDelimitedString(transactionIds), doCalcs, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public KrakenOrderResponse placeKrakenMarketOrder(MarketOrder marketOrder) throws IOException {
        KrakenType type = KrakenType.fromOrderType(marketOrder.getType());
        KrakenStandardOrder.KrakenOrderBuilder orderBuilder = KrakenStandardOrder.getMarketOrderBuilder(marketOrder.getCurrencyPair(), type, marketOrder.getOriginalAmount()).withOrderFlags(marketOrder.getOrderFlags());
        return this.placeKrakenOrder(orderBuilder.buildOrder());
    }

    public KrakenOrderResponse placeKrakenLimitOrder(LimitOrder limitOrder) throws IOException {
        KrakenType type = KrakenType.fromOrderType(limitOrder.getType());
        KrakenStandardOrder.KrakenOrderBuilder krakenOrderBuilder = KrakenStandardOrder.getLimitOrderBuilder(limitOrder.getCurrencyPair(), type, limitOrder.getLimitPrice().toPlainString(), limitOrder.getOriginalAmount()).withOrderFlags(limitOrder.getOrderFlags());
        return this.placeKrakenOrder(krakenOrderBuilder.buildOrder());
    }

    public KrakenOrderResponse placeKrakenOrder(KrakenStandardOrder krakenStandardOrder) throws IOException {
        KrakenOrderResult result = null;
        result = !krakenStandardOrder.isValidateOnly() ? this.kraken.addOrder(KrakenUtils.createKrakenCurrencyPair(krakenStandardOrder.getAssetPair()), krakenStandardOrder.getType().toString(), krakenStandardOrder.getOrderType().toApiFormat(), krakenStandardOrder.getPrice(), krakenStandardOrder.getSecondaryPrice(), krakenStandardOrder.getVolume().toPlainString(), krakenStandardOrder.getLeverage(), krakenStandardOrder.getPositionTxId(), this.delimitSet(krakenStandardOrder.getOrderFlags()), krakenStandardOrder.getStartTime(), krakenStandardOrder.getExpireTime(), krakenStandardOrder.getUserRefId(), krakenStandardOrder.getCloseOrder(), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory()) : this.kraken.addOrderValidateOnly(KrakenUtils.createKrakenCurrencyPair(krakenStandardOrder.getAssetPair()), krakenStandardOrder.getType().toString(), krakenStandardOrder.getOrderType().toApiFormat(), krakenStandardOrder.getPrice(), krakenStandardOrder.getSecondaryPrice(), krakenStandardOrder.getVolume().toPlainString(), krakenStandardOrder.getLeverage(), krakenStandardOrder.getPositionTxId(), this.delimitSet(krakenStandardOrder.getOrderFlags()), krakenStandardOrder.getStartTime(), krakenStandardOrder.getExpireTime(), krakenStandardOrder.getUserRefId(), true, krakenStandardOrder.getCloseOrder(), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public KrakenCancelOrderResult.KrakenCancelOrderResponse cancelKrakenOrder(String orderId) throws IOException {
        KrakenCancelOrderResult result = this.kraken.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        return this.checkResult(result);
    }

    protected KrakenTradeVolume getTradeVolume(CurrencyPair ... currencyPairs) throws IOException {
        KrakenTradeVolumeResult result = this.kraken.tradeVolume(this.delimitAssetPairs(currencyPairs), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }
}

