/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderDescription;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderFlags;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderStatus;

public class KrakenOrder {
    private final String refId;
    private final String userRefId;
    private final KrakenOrderStatus status;
    private final double openTimestamp;
    private final double startTimestamp;
    private final double expireTimestamp;
    private final KrakenOrderDescription orderDescription;
    private final BigDecimal volume;
    private final BigDecimal volumeExecuted;
    private final BigDecimal cost;
    private final BigDecimal fee;
    private final BigDecimal price;
    private final BigDecimal stopPrice;
    private final BigDecimal limitPrice;
    private final String miscellaneous;
    private final Set<KrakenOrderFlags> orderFlags;
    private final List<String> tradeIds;
    private final double closeTimestamp;
    private final String closeReason;

    public KrakenOrder(@JsonProperty(value="refid") String refId, @JsonProperty(value="userref") String userRefId, @JsonProperty(value="status") KrakenOrderStatus status, @JsonProperty(value="opentm") double openTimestamp, @JsonProperty(value="starttm") double startTimestamp, @JsonProperty(value="expiretm") double expireTimestamp, @JsonProperty(value="descr") KrakenOrderDescription orderDescription, @JsonProperty(value="vol") BigDecimal volume, @JsonProperty(value="vol_exec") BigDecimal volumeExecuted, @JsonProperty(value="cost") BigDecimal cost, @JsonProperty(value="fee") BigDecimal fee, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="stopprice") BigDecimal stopPrice, @JsonProperty(value="limitprice") BigDecimal limitPrice, @JsonProperty(value="misc") String misc, @JsonProperty(value="oflags") @JsonDeserialize(using=KrakenOrderFlags.KrakenOrderFlagsDeserializer.class) Set<KrakenOrderFlags> orderFLags, @JsonProperty(value="trades") List<String> tradeIds, @JsonProperty(value="closetm") double closeTimestamp, @JsonProperty(value="reason") String closeReason) {
        this.refId = refId;
        this.userRefId = userRefId;
        this.status = status;
        this.openTimestamp = openTimestamp;
        this.startTimestamp = startTimestamp;
        this.expireTimestamp = expireTimestamp;
        this.orderDescription = orderDescription;
        this.volume = volume;
        this.volumeExecuted = volumeExecuted;
        this.cost = cost;
        this.fee = fee;
        this.price = price;
        this.stopPrice = stopPrice;
        this.limitPrice = limitPrice;
        this.miscellaneous = misc;
        this.orderFlags = orderFLags;
        this.tradeIds = tradeIds;
        this.closeTimestamp = closeTimestamp;
        this.closeReason = closeReason;
    }

    public KrakenOrderDescription getOrderDescription() {
        return this.orderDescription;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getUserRefId() {
        return this.userRefId;
    }

    public KrakenOrderStatus getStatus() {
        return this.status;
    }

    public double getOpenTimestamp() {
        return this.openTimestamp;
    }

    public double getStartTimestamp() {
        return this.startTimestamp;
    }

    public double getExpireTimestamp() {
        return this.expireTimestamp;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getVolumeExecuted() {
        return this.volumeExecuted;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getStopPrice() {
        return this.stopPrice;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    public String getMiscellaneous() {
        return this.miscellaneous;
    }

    public Set<KrakenOrderFlags> getOrderFlags() {
        return this.orderFlags;
    }

    public List<String> getTradeIds() {
        return this.tradeIds;
    }

    public double getCloseTimestamp() {
        return this.closeTimestamp;
    }

    public String getCloseReason() {
        return this.closeReason;
    }

    public String toString() {
        return "KrakenOrder [refId=" + this.refId + ", userRefId=" + this.userRefId + ", status=" + (Object)((Object)this.status) + ", openTimestamp=" + this.openTimestamp + ", startTimestamp=" + this.startTimestamp + ", expireTimestamp=" + this.expireTimestamp + ", orderDescription=" + this.orderDescription + ", volume=" + this.volume + ", volumeExecuted=" + this.volumeExecuted + ", cost=" + this.cost + ", fee=" + this.fee + ", price=" + this.price + ", stopPrice=" + this.stopPrice + ", limitPrice=" + this.limitPrice + ", miscellaneous=" + this.miscellaneous + ", orderFlags=" + this.orderFlags + ", tradeIds=" + this.tradeIds + ", closeTimestamp=" + this.closeTimestamp + ", closeReason=" + this.closeReason + "]";
    }
}

