/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.trade;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(using=KrakenOrderStatusDeserializer.class)
public enum KrakenOrderStatus {
    PENDING,
    OPEN,
    CLOSED,
    CANCELED,
    EXPIRED;

    private static final Map<String, KrakenOrderStatus> fromString;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static KrakenOrderStatus fromString(String orderStatusString) {
        return fromString.get(orderStatusString.toLowerCase());
    }

    static {
        fromString = new HashMap<String, KrakenOrderStatus>();
        for (KrakenOrderStatus orderStatus : KrakenOrderStatus.values()) {
            fromString.put(orderStatus.toString(), orderStatus);
        }
    }

    static class KrakenOrderStatusDeserializer
    extends JsonDeserializer<KrakenOrderStatus> {
        KrakenOrderStatusDeserializer() {
        }

        public KrakenOrderStatus deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String orderStatusString = node.textValue();
            return KrakenOrderStatus.fromString(orderStatusString);
        }
    }
}

