/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FrequencyLimitExceededException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.kraken.KrakenAuthenticated;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.KrakenResult;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssets;
import org.knowm.xchange.kraken.dto.marketdata.KrakenServerTime;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenAssetsResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenServerTimeResult;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderFlags;
import org.knowm.xchange.kraken.service.KrakenDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class KrakenBaseService
extends BaseExchangeService
implements BaseService {
    protected KrakenAuthenticated kraken;
    protected ParamsDigest signatureCreator;

    public KrakenBaseService(Exchange exchange) {
        super(exchange);
        this.kraken = (KrakenAuthenticated)RestProxyFactory.createProxy(KrakenAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.signatureCreator = KrakenDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public KrakenServerTime getServerTime() throws IOException {
        KrakenServerTimeResult timeResult = this.kraken.getServerTime();
        return this.checkResult(timeResult);
    }

    public KrakenAssets getKrakenAssets(Currency ... assets) throws IOException {
        KrakenAssetsResult assetPairsResult = this.kraken.getAssets(null, this.delimitAssets(assets));
        return new KrakenAssets(this.checkResult(assetPairsResult));
    }

    protected <R> R checkResult(KrakenResult<R> krakenResult) {
        if (!krakenResult.isSuccess()) {
            Object[] errors = krakenResult.getError();
            if (errors.length == 0) {
                throw new ExchangeException("Missing error message");
            }
            String error = errors[0];
            if ("EAPI:Invalid nonce".equals(error)) {
                throw new NonceException(error);
            }
            if ("EGeneral:Temporary lockout".equals(error)) {
                throw new FrequencyLimitExceededException(error);
            }
            throw new ExchangeException(Arrays.toString(errors));
        }
        return krakenResult.getResult();
    }

    protected String createDelimitedString(String[] items) {
        StringBuilder commaDelimitedString = null;
        if (items != null) {
            for (String item : items) {
                if (commaDelimitedString == null) {
                    commaDelimitedString = new StringBuilder(item);
                    continue;
                }
                commaDelimitedString.append(",").append(item);
            }
        }
        return commaDelimitedString == null ? null : commaDelimitedString.toString();
    }

    protected String delimitAssets(Currency[] assets) throws IOException {
        StringBuilder commaDelimitedAssets = new StringBuilder();
        if (assets != null && assets.length > 0) {
            boolean started = false;
            for (Currency asset : assets) {
                commaDelimitedAssets.append(started ? "," : "").append(KrakenUtils.getKrakenCurrencyCode(asset));
                started = true;
            }
            return commaDelimitedAssets.toString();
        }
        return null;
    }

    protected String delimitAssetPairs(CurrencyPair[] currencyPairs) throws IOException {
        String assetPairsString = null;
        if (currencyPairs != null && currencyPairs.length > 0) {
            StringBuilder delimitStringBuilder = null;
            for (CurrencyPair currencyPair : currencyPairs) {
                String krakenAssetPair = KrakenUtils.createKrakenCurrencyPair(currencyPair);
                if (delimitStringBuilder == null) {
                    delimitStringBuilder = new StringBuilder(krakenAssetPair);
                    continue;
                }
                delimitStringBuilder.append(",").append(krakenAssetPair);
            }
            assetPairsString = delimitStringBuilder.toString();
        }
        return assetPairsString;
    }

    protected String delimitSet(Set<Order.IOrderFlags> items) {
        String delimitedSetString = null;
        if (items != null && !items.isEmpty()) {
            StringBuilder delimitStringBuilder = null;
            for (Order.IOrderFlags item : items) {
                if (!(item instanceof KrakenOrderFlags)) continue;
                if (delimitStringBuilder == null) {
                    delimitStringBuilder = new StringBuilder(item.toString());
                    continue;
                }
                delimitStringBuilder.append(",").append(item.toString());
            }
            if (delimitStringBuilder != null) {
                delimitedSetString = delimitStringBuilder.toString();
            }
        }
        return delimitedSetString;
    }
}

