/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssetPairs;
import org.knowm.xchange.kraken.dto.marketdata.KrakenDepth;
import org.knowm.xchange.kraken.dto.marketdata.KrakenOHLCs;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicTrades;
import org.knowm.xchange.kraken.dto.marketdata.KrakenSpreads;
import org.knowm.xchange.kraken.dto.marketdata.KrakenTicker;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenAssetPairsResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenDepthResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenOHLCResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenPublicTradesResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenSpreadsResult;
import org.knowm.xchange.kraken.dto.marketdata.results.KrakenTickerResult;
import org.knowm.xchange.kraken.service.KrakenBaseService;

public class KrakenMarketDataServiceRaw
extends KrakenBaseService {
    public KrakenMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public KrakenOHLCs getKrakenOHLC(CurrencyPair currencyPair) throws IOException {
        return this.getKrakenOHLC(currencyPair, null, null);
    }

    public KrakenOHLCs getKrakenOHLC(CurrencyPair currencyPair, Integer interval, Long since) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(currencyPair);
        KrakenOHLCResult OHLCResult = this.kraken.getOHLC(krakenCurrencyPair, interval, since);
        return this.checkResult(OHLCResult);
    }

    public KrakenTicker getKrakenTicker(CurrencyPair currencyPair) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(currencyPair);
        KrakenTickerResult tickerResult = this.kraken.getTicker(krakenCurrencyPair);
        return this.checkResult(tickerResult).get(krakenCurrencyPair);
    }

    public Map<String, KrakenTicker> getKrakenTicker(CurrencyPair ... currencyPairs) throws IOException {
        KrakenTickerResult tickerResult = this.kraken.getTicker(this.delimitAssetPairs(currencyPairs));
        return this.checkResult(tickerResult);
    }

    public KrakenDepth getKrakenDepth(CurrencyPair currencyPair, long count) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(currencyPair);
        KrakenDepthResult result = this.kraken.getDepth(krakenCurrencyPair, count);
        return this.checkResult(result).get(krakenCurrencyPair);
    }

    public KrakenPublicTrades getKrakenTrades(CurrencyPair currencyPair) throws IOException {
        return this.getKrakenTrades(currencyPair, null);
    }

    public KrakenPublicTrades getKrakenTrades(CurrencyPair currencyPair, Long since) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(currencyPair);
        KrakenPublicTradesResult result = this.kraken.getTrades(krakenCurrencyPair, since);
        return this.checkResult(result);
    }

    public KrakenSpreads getKrakenSpreads(Currency tradableIdentifier, Currency currency) throws IOException {
        return this.getKrakenSpreads(tradableIdentifier, currency, null);
    }

    private KrakenSpreads getKrakenSpreads(Currency tradableIdentifier, Currency currency, Long since) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenSpreadsResult spreadsResult = this.kraken.getSpread(krakenCurrencyPair, since);
        return this.checkResult(spreadsResult);
    }

    public KrakenAssetPairs getKrakenAssetPairs(CurrencyPair ... currencyPairs) throws IOException {
        KrakenAssetPairsResult assetPairsResult = this.kraken.getAssetPairs(this.delimitAssetPairs(currencyPairs));
        return new KrakenAssetPairs(this.checkResult(assetPairsResult));
    }
}

