/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.kraken.KrakenAdapters;
import org.knowm.xchange.kraken.service.KrakenTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class KrakenTradeService
extends KrakenTradeServiceRaw
implements TradeService {
    public KrakenTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        return KrakenAdapters.adaptOpenOrders(super.getKrakenOpenOrders());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return KrakenAdapters.adaptOrderId(super.placeKrakenMarketOrder(marketOrder));
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return KrakenAdapters.adaptOrderId(super.placeKrakenLimitOrder(limitOrder));
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return super.cancelKrakenOrder(orderId).getCount() > 0;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws ExchangeException, IOException {
        Long endTime;
        Long startTime;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpan = (TradeHistoryParamsTimeSpan)params;
            startTime = DateUtils.toUnixTimeNullSafe((Date)timeSpan.getStartTime());
            endTime = DateUtils.toUnixTimeNullSafe((Date)timeSpan.getEndTime());
        } else {
            startTime = null;
            endTime = null;
        }
        Long offset = params instanceof TradeHistoryParamOffset ? ((TradeHistoryParamOffset)params).getOffset() : null;
        return KrakenAdapters.adaptTradesHistory(this.getKrakenTradeHistory(null, false, startTime, endTime, offset));
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new KrakenTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public static class KrakenTradeHistoryParams
    extends DefaultTradeHistoryParamsTimeSpan
    implements TradeHistoryParamOffset {
        private Long offset;

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public Long getOffset() {
            return this.offset;
        }
    }
}

