/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lakebtc;

import java.io.IOException;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.lakebtc.dto.marketdata.LakeBTCOrderBook;
import org.knowm.xchange.lakebtc.dto.marketdata.LakeBTCTickers;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@Path(value="api_v2")
@Produces(value={"application/json"})
public interface LakeBTC {
    @GET
    @Path(value="ticker")
    public LakeBTCTickers getLakeBTCTickers() throws IOException;

    @GET
    @Path(value="bcorderbook?symbol={pair}")
    public LakeBTCOrderBook getLakeBTCOrderBookUSD(@PathParam(value="pair") Pair var1) throws IOException;

    public static class Pair {
        public final CurrencyPair pair;

        public Pair(CurrencyPair pair) {
            this.pair = pair;
        }

        public Pair(String pair) {
            this(CurrencyPairDeserializer.getCurrencyPairFromString((String)pair));
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.pair, ((Pair)o).pair);
        }

        public int hashCode() {
            return Objects.hash(this.pair);
        }

        public String toString() {
            return this.pair == null ? "" : String.format("%s%s", this.pair.base.getCurrencyCode().toLowerCase(), this.pair.counter.getCurrencyCode().toLowerCase());
        }
    }
}

