/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lakebtc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.lakebtc.dto.account.LakeBTCAccount;
import org.knowm.xchange.lakebtc.dto.account.LakeBTCBalance;
import org.knowm.xchange.lakebtc.dto.account.LakeBTCProfile;
import org.knowm.xchange.lakebtc.dto.marketdata.LakeBTCOrderBook;
import org.knowm.xchange.lakebtc.dto.marketdata.LakeBTCTicker;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCTradeResponse;
import org.knowm.xchange.utils.DateUtils;

public class LakeBTCAdapters {
    private LakeBTCAdapters() {
    }

    public static Ticker adaptTicker(LakeBTCTicker lakeBTCTicker, CurrencyPair currencyPair) {
        BigDecimal ask = lakeBTCTicker.getAsk();
        BigDecimal bid = lakeBTCTicker.getBid();
        BigDecimal high = lakeBTCTicker.getHigh();
        BigDecimal low = lakeBTCTicker.getLow();
        BigDecimal last = lakeBTCTicker.getLast();
        BigDecimal volume = lakeBTCTicker.getVolume();
        return new Ticker.Builder().currencyPair(currencyPair).bid(bid).ask(ask).high(high).low(low).last(last).volume(volume).build();
    }

    private static List<LimitOrder> transformArrayToLimitOrders(BigDecimal[][] orders, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] order : orders) {
            limitOrders.add(new LimitOrder(orderType, order[1], currencyPair, null, null, order[0]));
        }
        return limitOrders;
    }

    public static OrderBook adaptOrderBook(LakeBTCOrderBook lakeBTCOrderBook, CurrencyPair currencyPair) {
        return new OrderBook(null, LakeBTCAdapters.transformArrayToLimitOrders(lakeBTCOrderBook.getAsks(), Order.OrderType.ASK, currencyPair), LakeBTCAdapters.transformArrayToLimitOrders(lakeBTCOrderBook.getBids(), Order.OrderType.BID, currencyPair));
    }

    public static Trades adaptTrades(LakeBTCTradeResponse[] transactions, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (LakeBTCTradeResponse trade : transactions) {
            Order.OrderType orderType = trade.getType().startsWith("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            trades.add(new Trade(orderType, trade.getAmount(), currencyPair, trade.getTotal(), DateUtils.fromMillisUtc((long)(trade.getAt() * 1000L)), trade.getId()));
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptTrade(LakeBTCTradeResponse tx, CurrencyPair currencyPair, int timeScale) {
        String tradeId = String.valueOf(tx.getId());
        Date date = DateUtils.fromMillisUtc((long)(tx.getAt() * (long)timeScale));
        return new Trade(null, tx.getAmount(), currencyPair, tx.getTotal(), date, tradeId);
    }

    public static UserTrades adaptTradeHistory(LakeBTCTradeResponse[] transactions) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        long lastTradeId = 0L;
        for (LakeBTCTradeResponse trade : transactions) {
            Order.OrderType orderType = trade.getType().startsWith("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            BigDecimal originalAmount = trade.getAmount();
            BigDecimal price = trade.getTotal().abs();
            Date timestamp = DateUtils.fromMillisUtc((long)(trade.getAt() * 1000L));
            String tradeId = trade.getId();
            CurrencyPair currencyPair = CurrencyPair.BTC_CNY;
            UserTrade userTrade = new UserTrade(orderType, originalAmount, currencyPair, price, timestamp, tradeId, null, null, Currency.getInstance((String)currencyPair.counter.getCurrencyCode()));
            trades.add(userTrade);
        }
        return new UserTrades(trades, lastTradeId, Trades.TradeSortType.SortByTimestamp);
    }

    public static AccountInfo adaptAccountInfo(LakeBTCAccount lakeBTCAccount) {
        LakeBTCProfile profile = lakeBTCAccount.getProfile();
        LakeBTCBalance balance = lakeBTCAccount.getBalance();
        Balance usdBalance = new Balance(Currency.USD, balance.getUSD());
        Balance cnyWBalance = new Balance(Currency.CNY, balance.getCNY());
        Balance btcBalance = new Balance(Currency.BTC, balance.getBTC());
        return new AccountInfo(profile.getId(), new Wallet[]{new Wallet(new Balance[]{usdBalance, btcBalance, cnyWBalance})});
    }
}

