/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lakebtc.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.lakebtc.LakeBTC;
import org.knowm.xchange.lakebtc.LakeBTCAuthenticated;
import org.knowm.xchange.lakebtc.dto.LakeBTCResponse;
import org.knowm.xchange.lakebtc.service.LakeBTCDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import org.knowm.xchange.utils.Assert;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class LakeBTCBaseService
extends BaseExchangeService
implements BaseService {
    protected final LakeBTCAuthenticated lakeBTCAuthenticated;
    protected final ParamsDigest signatureCreator;
    protected final LakeBTC lakeBTC;

    public LakeBTCBaseService(Exchange exchange) {
        super(exchange);
        Assert.notNull((Object)exchange.getExchangeSpecification().getSslUri(), (String)"Exchange specification URI cannot be null");
        this.lakeBTCAuthenticated = (LakeBTCAuthenticated)RestProxyFactory.createProxy(LakeBTCAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.signatureCreator = LakeBTCDigest.createInstance(exchange.getExchangeSpecification().getUserName(), exchange.getExchangeSpecification().getSecretKey());
        this.lakeBTC = (LakeBTC)RestProxyFactory.createProxy(LakeBTC.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
    }

    public static <T extends LakeBTCResponse> T checkResult(T returnObject) {
        if (returnObject.getResult() == null) {
            throw new ExchangeException("Null data returned");
        }
        return returnObject;
    }
}

