/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lakebtc.service;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.knowm.xchange.lakebtc.LakeBTCUtil;
import org.knowm.xchange.lakebtc.dto.LakeBTCRequest;
import org.knowm.xchange.service.BaseParamsDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.BasicAuthCredentials;
import si.mazi.rescu.RestInvocation;

public class LakeBTCDigest
extends BaseParamsDigest {
    private final Logger log = LoggerFactory.getLogger(LakeBTCDigest.class);
    private final String clientId;
    private final String apiKey;

    private LakeBTCDigest(String clientId, String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA1");
        this.clientId = clientId;
        this.apiKey = secretKeyBase64;
    }

    public static LakeBTCDigest createInstance(String clientId, String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new LakeBTCDigest(clientId, secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        String tonce = (String)restInvocation.getHttpHeadersFromParams().get("Json-Rpc-Tonce");
        LakeBTCRequest request = null;
        for (Object param : restInvocation.getUnannanotatedParams()) {
            if (!(param instanceof LakeBTCRequest)) continue;
            request = (LakeBTCRequest)param;
        }
        if (request == null) {
            throw new IllegalArgumentException("No LakeBTCDigest found.");
        }
        long id = request.getId();
        String method = request.getRequestMethod();
        String params = "";
        String signature = String.format("tonce=%s&accesskey=%s&requestmethod=%s&id=%d&method=%s&params=%s", tonce, this.clientId, method, id, request.getMethod(), "");
        this.log.debug("signature message: {}", (Object)signature);
        Mac mac = this.getMac();
        byte[] hash = mac.doFinal(signature.getBytes());
        BasicAuthCredentials auth = new BasicAuthCredentials(this.apiKey, LakeBTCUtil.bytesToHex(hash));
        return auth.digestParams(restInvocation);
    }

    public static String makeSign(String data, String key) throws Exception {
        SecretKeySpec sign = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sign);
        byte[] rawHmac = mac.doFinal(data.getBytes());
        return LakeBTCDigest.arrayHex(rawHmac);
    }

    private static String arrayHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

