/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lakebtc.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.lakebtc.LakeBTCUtil;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCBuyOrderRequest;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCCancelRequest;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCCancelResponse;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCOrderResponse;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCOrdersRequest;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCOrdersResponse;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCSellOrderRequest;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCTradeResponse;
import org.knowm.xchange.lakebtc.dto.trade.LakeBTCTradesRequest;
import org.knowm.xchange.lakebtc.service.LakeBTCBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class LakeBTCTradeServiceRaw
extends LakeBTCBaseService {
    public LakeBTCTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public LakeBTCOrderResponse placeLakeBTCMarketOrder(MarketOrder marketOrder) throws IOException {
        String pair = LakeBTCUtil.toPairString(marketOrder.getCurrencyPair());
        try {
            LakeBTCOrderResponse newOrder = null;
            switch (marketOrder.getType()) {
                case BID: {
                    newOrder = this.lakeBTCAuthenticated.placeBuyOrder(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCBuyOrderRequest(String.format("\"%s,%s,%s\"", "0", marketOrder.getOriginalAmount().toString(), pair)));
                    break;
                }
                case ASK: {
                    newOrder = this.lakeBTCAuthenticated.placeSellOrder(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCSellOrderRequest(String.format("\"%s,%s,%s\"", "0", marketOrder.getOriginalAmount().toString(), pair)));
                }
            }
            return newOrder;
        }
        catch (IOException e) {
            throw new ExchangeException("LakeBTC returned an error", (Throwable)e);
        }
    }

    public LakeBTCOrderResponse placeLakeBTCLimitOrder(LimitOrder limitOrder) throws IOException {
        String pair = LakeBTCUtil.toPairString(limitOrder.getCurrencyPair());
        try {
            LakeBTCOrderResponse newOrder = null;
            switch (limitOrder.getType()) {
                case BID: {
                    newOrder = this.lakeBTCAuthenticated.placeBuyOrder(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCBuyOrderRequest(String.format("\"%s,%s,%s\"", limitOrder.getLimitPrice(), limitOrder.getOriginalAmount().toString(), pair)));
                    break;
                }
                case ASK: {
                    newOrder = this.lakeBTCAuthenticated.placeSellOrder(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCSellOrderRequest(String.format("\"%s,%s,%s\"", limitOrder.getLimitPrice(), limitOrder.getOriginalAmount().toString(), pair)));
                }
            }
            return newOrder;
        }
        catch (IOException e) {
            throw new ExchangeException("LakeBTC returned an error", (Throwable)e);
        }
    }

    public LakeBTCCancelResponse cancelLakeBTCOrder(String orderId) throws IOException {
        try {
            return this.lakeBTCAuthenticated.cancelOrder(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCCancelRequest(orderId));
        }
        catch (Exception e) {
            throw new ExchangeException("LakeBTC returned an error", (Throwable)e);
        }
    }

    public LakeBTCTradeResponse[] getLakeBTCTradeHistory(long timestamp) throws IOException {
        try {
            return this.lakeBTCAuthenticated.pastTrades(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCTradesRequest(String.valueOf(timestamp)));
        }
        catch (IOException e) {
            throw new ExchangeException("LakeBTC returned an error", (Throwable)e);
        }
    }

    public LakeBTCOrdersResponse[] getLakeBTCOrders() throws IOException {
        return this.lakeBTCAuthenticated.getOrders(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new LakeBTCOrdersRequest());
    }
}

