/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.okcoin.dto.account.OkCoinAccountRecords;
import org.knowm.xchange.okcoin.dto.account.OkCoinFunds;
import org.knowm.xchange.okcoin.dto.account.OkCoinFuturesInfoCross;
import org.knowm.xchange.okcoin.dto.account.OkCoinFuturesUserInfoCross;
import org.knowm.xchange.okcoin.dto.account.OkCoinRecords;
import org.knowm.xchange.okcoin.dto.account.OkCoinUserInfo;
import org.knowm.xchange.okcoin.dto.account.OkcoinFuturesFundsCross;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinDepth;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTickerResponse;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTrade;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrder;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesTradeHistoryResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrder;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrderResult;
import org.knowm.xchange.utils.DateUtils;

public final class OkCoinAdapters {
    private static final Balance zeroUsdBalance = new Balance(Currency.USD, BigDecimal.ZERO);

    private OkCoinAdapters() {
    }

    private static BigDecimal getOrZero(String key, Map<String, BigDecimal> map) {
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return BigDecimal.ZERO;
    }

    public static String adaptSymbol(CurrencyPair currencyPair) {
        return currencyPair.base.getCurrencyCode().toLowerCase() + "_" + currencyPair.counter.getCurrencyCode().toLowerCase();
    }

    public static String adaptSymbol(Currency currency) {
        return currency.getCurrencyCode().toLowerCase();
    }

    public static CurrencyPair adaptSymbol(String symbol) {
        String[] currencies = symbol.toUpperCase().split("_");
        return new CurrencyPair(currencies[0], currencies[1]);
    }

    public static Ticker adaptTicker(OkCoinTickerResponse tickerResponse, CurrencyPair currencyPair) {
        Date date = OkCoinAdapters.adaptDate(tickerResponse.getDate());
        return new Ticker.Builder().currencyPair(currencyPair).high(tickerResponse.getTicker().getHigh()).low(tickerResponse.getTicker().getLow()).bid(tickerResponse.getTicker().getBuy()).ask(tickerResponse.getTicker().getSell()).last(tickerResponse.getTicker().getLast()).volume(tickerResponse.getTicker().getVol()).timestamp(date).build();
    }

    public static OrderBook adaptOrderBook(OkCoinDepth depth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = OkCoinAdapters.adaptLimitOrders(Order.OrderType.ASK, depth.getAsks(), currencyPair);
        Collections.reverse(asks);
        List<LimitOrder> bids = OkCoinAdapters.adaptLimitOrders(Order.OrderType.BID, depth.getBids(), currencyPair);
        return new OrderBook(depth.getTimestamp(), asks, bids);
    }

    public static Trades adaptTrades(OkCoinTrade[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradeList = new ArrayList<Trade>(trades.length);
        for (int i = 0; i < trades.length; ++i) {
            OkCoinTrade trade = trades[i];
            tradeList.add(OkCoinAdapters.adaptTrade(trade, currencyPair));
        }
        long lastTid = trades.length > 0 ? trades[trades.length - 1].getTid() : 0L;
        return new Trades(tradeList, lastTid, Trades.TradeSortType.SortByTimestamp);
    }

    public static AccountInfo adaptAccountInfo(OkCoinUserInfo userInfo) {
        Balance.Builder builder2;
        OkCoinFunds funds = userInfo.getInfo().getFunds();
        TreeMap<String, Balance.Builder> builders = new TreeMap<String, Balance.Builder>();
        for (Map.Entry<String, BigDecimal> available : funds.getFree().entrySet()) {
            builders.put(available.getKey(), new Balance.Builder().currency(Currency.getInstance((String)available.getKey())).available(available.getValue()));
        }
        for (Map.Entry<String, BigDecimal> frozen : funds.getFreezed().entrySet()) {
            builder2 = (Balance.Builder)builders.get(frozen.getKey());
            if (builder2 == null) {
                builder2 = new Balance.Builder().currency(Currency.getInstance((String)frozen.getKey()));
            }
            builders.put(frozen.getKey(), builder2.frozen(frozen.getValue()));
        }
        for (Map.Entry<String, BigDecimal> borrowed : funds.getBorrow().entrySet()) {
            builder2 = (Balance.Builder)builders.get(borrowed.getKey());
            if (builder2 == null) {
                builder2 = new Balance.Builder().currency(Currency.getInstance((String)borrowed.getKey()));
            }
            builders.put(borrowed.getKey(), builder2.borrowed(borrowed.getValue()));
        }
        ArrayList<Balance> wallet = new ArrayList<Balance>(builders.size());
        for (Balance.Builder builder2 : builders.values()) {
            wallet.add(builder2.build());
        }
        return new AccountInfo(new Wallet[]{new Wallet(wallet)});
    }

    public static AccountInfo adaptAccountInfoFutures(OkCoinFuturesUserInfoCross futureUserInfo) {
        OkCoinFuturesInfoCross info = futureUserInfo.getInfo();
        OkcoinFuturesFundsCross btcFunds = info.getBtcFunds();
        OkcoinFuturesFundsCross ltcFunds = info.getLtcFunds();
        OkcoinFuturesFundsCross bchFunds = info.getBchFunds();
        Balance btcBalance = new Balance(Currency.BTC, btcFunds.getAccountRights());
        Balance ltcBalance = new Balance(Currency.LTC, ltcFunds.getAccountRights());
        Balance bchBalance = new Balance(Currency.BCH, bchFunds.getAccountRights());
        return new AccountInfo(new Wallet[]{new Wallet(new Balance[]{zeroUsdBalance, btcBalance, ltcBalance, bchBalance})});
    }

    public static OpenOrders adaptOpenOrders(List<OkCoinOrderResult> orderResults) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (int i = 0; i < orderResults.size(); ++i) {
            OkCoinOrderResult orderResult = orderResults.get(i);
            OkCoinOrder[] orders = orderResult.getOrders();
            for (int j = 0; j < orders.length; ++j) {
                OkCoinOrder singleOrder = orders[j];
                openOrders.add(OkCoinAdapters.adaptOpenOrder(singleOrder));
            }
        }
        return new OpenOrders(openOrders);
    }

    public static OpenOrders adaptOpenOrdersFutures(List<OkCoinFuturesOrderResult> orderResults) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (int i = 0; i < orderResults.size(); ++i) {
            OkCoinFuturesOrderResult orderResult = orderResults.get(i);
            OkCoinFuturesOrder[] orders = orderResult.getOrders();
            for (int j = 0; j < orders.length; ++j) {
                OkCoinFuturesOrder singleOrder = orders[j];
                openOrders.add(OkCoinAdapters.adaptOpenOrderFutures(singleOrder));
            }
        }
        return new OpenOrders(openOrders);
    }

    public static UserTrades adaptTrades(OkCoinOrderResult orderResult) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(orderResult.getOrders().length);
        for (int i = 0; i < orderResult.getOrders().length; ++i) {
            OkCoinOrder order = orderResult.getOrders()[i];
            if (order.getDealAmount().equals(BigDecimal.ZERO)) continue;
            trades.add(OkCoinAdapters.adaptTrade(order));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrades adaptTradesFutures(OkCoinFuturesOrderResult orderResult) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(orderResult.getOrders().length);
        for (int i = 0; i < orderResult.getOrders().length; ++i) {
            OkCoinFuturesOrder order = orderResult.getOrders()[i];
            if (order.getDealAmount().equals(BigDecimal.ZERO)) continue;
            trades.add(OkCoinAdapters.adaptTradeFutures(order));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    private static List<LimitOrder> adaptLimitOrders(Order.OrderType type, BigDecimal[][] list, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(list.length);
        for (int i = 0; i < list.length; ++i) {
            BigDecimal[] data = list[i];
            limitOrders.add(OkCoinAdapters.adaptLimitOrder(type, data, currencyPair, null, null));
        }
        return limitOrders;
    }

    private static LimitOrder adaptLimitOrder(Order.OrderType type, BigDecimal[] data, CurrencyPair currencyPair, String id, Date timestamp) {
        return new LimitOrder(type, data[1], currencyPair, id, timestamp, data[0]);
    }

    private static Trade adaptTrade(OkCoinTrade trade, CurrencyPair currencyPair) {
        return new Trade(trade.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK, trade.getAmount(), currencyPair, trade.getPrice(), trade.getDate(), "" + trade.getTid());
    }

    private static LimitOrder adaptOpenOrder(OkCoinOrder order) {
        return new LimitOrder(OkCoinAdapters.adaptOrderType(order.getType()), order.getAmount(), OkCoinAdapters.adaptSymbol(order.getSymbol()), String.valueOf(order.getOrderId()), order.getCreateDate(), order.getPrice(), order.getAveragePrice(), order.getDealAmount(), OkCoinAdapters.adaptOrderStatus(order.getStatus()));
    }

    public static LimitOrder adaptOpenOrderFutures(OkCoinFuturesOrder order) {
        return new LimitOrder(OkCoinAdapters.adaptOrderType(order.getType()), order.getAmount(), OkCoinAdapters.adaptSymbol(order.getSymbol()), String.valueOf(order.getOrderId()), order.getCreatedDate(), order.getPrice(), order.getAvgPrice(), order.getDealAmount(), OkCoinAdapters.adaptOrderStatus(order.getStatus()));
    }

    public static Order.OrderType adaptOrderType(String type) {
        switch (type) {
            case "buy": {
                return Order.OrderType.BID;
            }
            case "buy_market": {
                return Order.OrderType.BID;
            }
            case "sell": {
                return Order.OrderType.ASK;
            }
            case "sell_market": {
                return Order.OrderType.ASK;
            }
            case "1": {
                return Order.OrderType.BID;
            }
            case "2": {
                return Order.OrderType.ASK;
            }
            case "3": {
                return Order.OrderType.EXIT_ASK;
            }
            case "4": {
                return Order.OrderType.EXIT_BID;
            }
        }
        return null;
    }

    public static Order.OrderStatus adaptOrderStatus(int status) {
        switch (status) {
            case -1: {
                return Order.OrderStatus.CANCELED;
            }
            case 0: {
                return Order.OrderStatus.NEW;
            }
            case 1: {
                return Order.OrderStatus.PARTIALLY_FILLED;
            }
            case 2: {
                return Order.OrderStatus.FILLED;
            }
            case 4: {
                return Order.OrderStatus.PENDING_CANCEL;
            }
        }
        return null;
    }

    private static UserTrade adaptTrade(OkCoinOrder order) {
        return new UserTrade(OkCoinAdapters.adaptOrderType(order.getType()), order.getDealAmount(), OkCoinAdapters.adaptSymbol(order.getSymbol()), order.getPrice(), order.getCreateDate(), null, String.valueOf(order.getOrderId()), null, (Currency)null);
    }

    private static UserTrade adaptTradeFutures(OkCoinFuturesOrder order) {
        return new UserTrade(OkCoinAdapters.adaptOrderType(order.getType()), order.getDealAmount(), OkCoinAdapters.adaptSymbol(order.getSymbol()), order.getPrice(), order.getCreatedDate(), null, String.valueOf(order.getOrderId()), null, (Currency)null);
    }

    public static UserTrades adaptTradeHistory(OkCoinFuturesTradeHistoryResult[] okCoinFuturesTradeHistoryResult) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        long lastTradeId = 0L;
        for (OkCoinFuturesTradeHistoryResult okCoinFuturesTrade : okCoinFuturesTradeHistoryResult) {
            Order.OrderType orderType = okCoinFuturesTrade.getType().equals((Object)OkCoinFuturesTradeHistoryResult.TransactionType.sell) ? Order.OrderType.ASK : Order.OrderType.BID;
            BigDecimal originalAmount = BigDecimal.valueOf(okCoinFuturesTrade.getAmount());
            BigDecimal price = okCoinFuturesTrade.getPrice();
            Date timestamp = new Date(okCoinFuturesTrade.getTimestamp());
            long transactionId = okCoinFuturesTrade.getId();
            if (transactionId > lastTradeId) {
                lastTradeId = transactionId;
            }
            String tradeId = String.valueOf(transactionId);
            String orderId = String.valueOf(okCoinFuturesTrade.getId());
            CurrencyPair currencyPair = CurrencyPair.BTC_USD;
            BigDecimal feeAmont = BigDecimal.ZERO;
            UserTrade trade = new UserTrade(orderType, originalAmount, currencyPair, price, timestamp, tradeId, orderId, feeAmont, Currency.getInstance((String)currencyPair.counter.getCurrencyCode()));
            trades.add(trade);
        }
        return new UserTrades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    private static Date adaptDate(long date) {
        return DateUtils.fromMillisUtc((long)date);
    }

    public static List<FundingRecord> adaptFundingHistory(OkCoinAccountRecords[] okCoinAccountRecordsList) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        if (okCoinAccountRecordsList != null && okCoinAccountRecordsList.length > 0) {
            OkCoinAccountRecords withdrawalRecord;
            OkCoinAccountRecords depositRecord = okCoinAccountRecordsList[0];
            if (depositRecord != null) {
                Currency depositCurrency = Currency.getInstance((String)depositRecord.getSymbol());
                for (OkCoinRecords okCoinRecordEntry : depositRecord.getRecords()) {
                    OkCoinRecords.RechargeStatus rechargeStatus;
                    FundingRecord.Status status = null;
                    if (okCoinRecordEntry.getStatus() != null && (rechargeStatus = OkCoinRecords.RechargeStatus.fromInt(okCoinRecordEntry.getStatus())) != null) {
                        status = FundingRecord.Status.resolveStatus((String)rechargeStatus.getStatus());
                    }
                    fundingRecords.add(new FundingRecord(okCoinRecordEntry.getAddress(), OkCoinAdapters.adaptDate(okCoinRecordEntry.getDate()), depositCurrency, okCoinRecordEntry.getAmount(), null, null, FundingRecord.Type.DEPOSIT, status, null, okCoinRecordEntry.getFee(), null));
                }
            }
            if ((withdrawalRecord = okCoinAccountRecordsList[1]) != null) {
                Currency withdrawalCurrency = Currency.getInstance((String)withdrawalRecord.getSymbol());
                for (OkCoinRecords okCoinRecordEntry : withdrawalRecord.getRecords()) {
                    OkCoinRecords.WithdrawalStatus withdrawalStatus;
                    FundingRecord.Status status = null;
                    if (okCoinRecordEntry.getStatus() != null && (withdrawalStatus = OkCoinRecords.WithdrawalStatus.fromInt(okCoinRecordEntry.getStatus())) != null) {
                        status = FundingRecord.Status.resolveStatus((String)withdrawalStatus.getStatus());
                    }
                    fundingRecords.add(new FundingRecord(okCoinRecordEntry.getAddress(), OkCoinAdapters.adaptDate(okCoinRecordEntry.getDate()), withdrawalCurrency, okCoinRecordEntry.getAmount(), null, null, FundingRecord.Type.WITHDRAWAL, status, null, okCoinRecordEntry.getFee(), null));
                }
            }
        }
        return fundingRecords;
    }
}

