/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.ws.rs.FormParam;
import si.mazi.rescu.Params;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class OkCoinDigest
implements ParamsDigest {
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String apikey;
    private final String secretKey;
    private final MessageDigest md;
    private final Comparator<Map.Entry<String, String>> comparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public OkCoinDigest(String apikey, String secretKey) {
        this.apikey = apikey;
        this.secretKey = secretKey;
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Problem instantiating message digest.");
        }
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public String digestParams(RestInvocation restInvocation) {
        Params params = (Params)restInvocation.getParamsMap().get(FormParam.class);
        Map nameValueMap = params.asHttpHeaders();
        nameValueMap.remove("sign");
        nameValueMap.put("api_key", this.apikey);
        if (nameValueMap.containsKey("type") && ((String)nameValueMap.get("type")).contains("market")) {
            if (((String)nameValueMap.get("type")).equals("buy_market")) {
                nameValueMap.remove("amount");
            } else if (((String)nameValueMap.get("type")).equals("sell_market")) {
                nameValueMap.remove("price");
            }
        }
        ArrayList nameValueList = new ArrayList(nameValueMap.entrySet());
        Collections.sort(nameValueList, this.comparator);
        Params newParams = Params.of();
        for (int i = 0; i < nameValueList.size(); ++i) {
            Map.Entry param = (Map.Entry)nameValueList.get(i);
            newParams.add((String)param.getKey(), param.getValue());
        }
        String message = newParams.toString() + "&secret_key=" + this.secretKey;
        try {
            this.md.reset();
            byte[] digest = this.md.digest(message.getBytes("US-ASCII"));
            return String.valueOf(OkCoinDigest.encodeHex(digest, DIGITS_UPPER));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Codec error", e);
        }
    }
}

