/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.service.OkCoinAccountService;
import org.knowm.xchange.okcoin.service.OkCoinFuturesAccountService;
import org.knowm.xchange.okcoin.service.OkCoinFuturesMarketDataService;
import org.knowm.xchange.okcoin.service.OkCoinFuturesTradeService;
import org.knowm.xchange.okcoin.service.OkCoinMarketDataService;
import org.knowm.xchange.okcoin.service.OkCoinTradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public class OkCoinExchange
extends BaseExchange {
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        if (exchangeSpecification.getExchangeSpecificParametersItem("Use_Intl").equals(false) && exchangeSpecification.getExchangeSpecificParametersItem("Use_Futures").equals(true)) {
            throw new RuntimeException("Futures only available on international version. Set `Use_Intl` to true.");
        }
        OkCoinExchange.concludeHostParams(exchangeSpecification);
    }

    protected void initServices() {
        OkCoinExchange.concludeHostParams(this.exchangeSpecification);
        if (this.exchangeSpecification.getExchangeSpecificParameters() != null && this.exchangeSpecification.getExchangeSpecificParametersItem("Use_Futures").equals(true)) {
            FuturesContract contract = OkCoinExchange.futuresContractOfConfig(this.exchangeSpecification);
            this.marketDataService = new OkCoinFuturesMarketDataService((Exchange)this, contract);
            if (this.exchangeSpecification.getApiKey() != null) {
                this.accountService = new OkCoinFuturesAccountService((Exchange)this);
                this.tradeService = new OkCoinFuturesTradeService((Exchange)this, contract, OkCoinExchange.futuresLeverageOfConfig(this.exchangeSpecification));
            }
        } else {
            this.marketDataService = new OkCoinMarketDataService((Exchange)this);
            if (this.exchangeSpecification.getApiKey() != null) {
                this.accountService = new OkCoinAccountService((Exchange)this);
                this.tradeService = new OkCoinTradeService((Exchange)this);
            }
        }
    }

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null) {
            if (exchangeSpecification.getExchangeSpecificParametersItem("Use_Intl").equals(true) && exchangeSpecification.getExchangeSpecificParametersItem("Use_Futures").equals(false)) {
                exchangeSpecification.setSslUri("https://www.okex.com/api");
                exchangeSpecification.setHost("www.okex.com");
            } else if (exchangeSpecification.getExchangeSpecificParametersItem("Use_Intl").equals(true) && exchangeSpecification.getExchangeSpecificParametersItem("Use_Futures").equals(true)) {
                exchangeSpecification.setSslUri("https://www.okex.com/api");
                exchangeSpecification.setHost("www.okex.com");
            }
        }
    }

    private static int futuresLeverageOfConfig(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters().containsKey("Futures_Leverage")) {
            return Integer.valueOf((String)exchangeSpecification.getExchangeSpecificParameters().get("Futures_Leverage"));
        }
        return 10;
    }

    public static FuturesContract futuresContractOfConfig(ExchangeSpecification exchangeSpecification) {
        FuturesContract contract;
        if (exchangeSpecification.getExchangeSpecificParameters().containsKey("Futures_Contract")) {
            contract = (FuturesContract)((Object)exchangeSpecification.getExchangeSpecificParameters().get("Futures_Contract"));
        } else if (exchangeSpecification.getExchangeSpecificParameters().containsKey("Futures_Contract_String")) {
            contract = FuturesContract.valueOfIgnoreCase(FuturesContract.class, (String)exchangeSpecification.getExchangeSpecificParameters().get("Futures_Contract_String"));
        } else {
            throw new RuntimeException("`Futures_Contract` or `Futures_Contract_String` not defined in exchange specific parameters.");
        }
        return contract;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://www.okex.cn/api");
        exchangeSpecification.setHost("www.okex.cn");
        exchangeSpecification.setExchangeName("OKCoin");
        exchangeSpecification.setExchangeDescription("OKCoin is a globally oriented crypto-currency trading platform.");
        exchangeSpecification.setExchangeSpecificParametersItem("Use_Intl", (Object)false);
        exchangeSpecification.setExchangeSpecificParametersItem("Use_Futures", (Object)false);
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return null;
    }

    public String getMetaDataFileName(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParametersItem("Use_Intl").equals(false)) {
            return exchangeSpecification.getExchangeName().toLowerCase().replace(" ", "").replace("-", "").replace(".", "") + "_china";
        }
        if (exchangeSpecification.getExchangeSpecificParametersItem("Use_Futures").equals(true)) {
            return exchangeSpecification.getExchangeName().toLowerCase().replace(" ", "").replace("-", "").replace(".", "") + "_futures";
        }
        return exchangeSpecification.getExchangeName().toLowerCase().replace(" ", "").replace("-", "").replace(".", "") + "_intl";
    }
}

