/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.okcoin.dto.account.OKCoinWithdraw;
import org.knowm.xchange.okcoin.dto.account.OkCoinAccountRecords;
import org.knowm.xchange.okcoin.dto.account.OkCoinFuturesUserInfoCross;
import org.knowm.xchange.okcoin.dto.account.OkCoinUserInfo;
import org.knowm.xchange.okcoin.service.OKCoinBaseTradeService;

public class OkCoinAccountServiceRaw
extends OKCoinBaseTradeService {
    private final String tradepwd;

    protected OkCoinAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.tradepwd = (String)exchange.getExchangeSpecification().getExchangeSpecificParametersItem("tradepwd");
    }

    public OkCoinUserInfo getUserInfo() throws IOException {
        OkCoinUserInfo userInfo = this.okCoin.getUserInfo(this.apikey, this.signatureCreator);
        return OkCoinAccountServiceRaw.returnOrThrow(userInfo);
    }

    public OkCoinFuturesUserInfoCross getFutureUserInfo() throws IOException {
        OkCoinFuturesUserInfoCross futuresUserInfoCross = this.okCoin.getFuturesUserInfoCross(this.apikey, this.signatureCreator);
        return OkCoinAccountServiceRaw.returnOrThrow(futuresUserInfoCross);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OKCoinWithdraw withdraw(String currencySymbol, String withdrawAddress, BigDecimal amount, String target) throws IOException {
        String fee = null;
        if (target.equals("address")) {
            if (currencySymbol.startsWith("btc")) {
                fee = "0.002";
            } else if (currencySymbol.startsWith("ltc")) {
                fee = "0.001";
            } else {
                if (!currencySymbol.startsWith("eth")) throw new IllegalArgumentException("Unsupported withdraw currency");
                fee = "0.01";
            }
        } else {
            if (!target.equals("okex") && !target.equals("okcn") && !target.equals("okcom")) throw new IllegalArgumentException("Unsupported withdraw target");
            fee = "0";
        }
        OKCoinWithdraw withdrawResult = this.okCoin.withdraw(this.exchange.getExchangeSpecification().getApiKey(), currencySymbol, this.signatureCreator, fee, this.tradepwd, withdrawAddress, amount.toString(), target);
        return OkCoinAccountServiceRaw.returnOrThrow(withdrawResult);
    }

    public OkCoinAccountRecords getAccountRecords(String symbol, String type, String currentPage, String pageLength) throws IOException {
        OkCoinAccountRecords accountRecords = this.okCoin.getAccountRecords(this.apikey, symbol, type, currentPage, pageLength, this.signatureCreator);
        return OkCoinAccountServiceRaw.returnOrThrow(accountRecords);
    }
}

