/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.OkCoinUtils;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrder;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesTradeHistoryResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinTradeResult;
import org.knowm.xchange.okcoin.service.OkCoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkCoinFuturesTradeService
extends OkCoinTradeServiceRaw
implements TradeService {
    private static final OpenOrders noOpenOrders = new OpenOrders(Collections.emptyList());
    private final Logger log = LoggerFactory.getLogger(OkCoinFuturesTradeService.class);
    private final int leverRate;
    private final int batchSize = 50;
    private final FuturesContract futuresContract;

    public OkCoinFuturesTradeService(Exchange exchange, FuturesContract futuresContract, int leverRate) {
        super(exchange);
        this.leverRate = leverRate;
        this.futuresContract = futuresContract;
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        List exchangeSymbols = this.exchange.getExchangeSymbols();
        ArrayList<OkCoinFuturesOrderResult> orderResults = new ArrayList<OkCoinFuturesOrderResult>(exchangeSymbols.size());
        for (int i = 0; i < exchangeSymbols.size(); ++i) {
            CurrencyPair symbol = (CurrencyPair)exchangeSymbols.get(i);
            this.log.debug("Getting order: {}", (Object)symbol);
            OkCoinFuturesOrderResult orderResult = this.getFuturesOrder(-1L, OkCoinAdapters.adaptSymbol(symbol), "0", "50", this.futuresContract);
            if (orderResult.getOrders().length <= 0) continue;
            orderResults.add(orderResult);
        }
        if (orderResults.size() <= 0) {
            return noOpenOrders;
        }
        return OkCoinAdapters.adaptOpenOrdersFutures(orderResults);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        if (marketOrder.getType() == Order.OrderType.BID || marketOrder.getType() == Order.OrderType.ASK) {
            long orderId = this.futuresTrade(OkCoinAdapters.adaptSymbol(marketOrder.getCurrencyPair()), marketOrder.getType() == Order.OrderType.BID ? "1" : "2", "0", marketOrder.getOriginalAmount().toPlainString(), this.futuresContract, 1, this.leverRate).getOrderId();
            return String.valueOf(orderId);
        }
        return this.liquidateMarketOrder(marketOrder);
    }

    public String liquidateMarketOrder(MarketOrder marketOrder) throws IOException {
        long orderId = this.futuresTrade(OkCoinAdapters.adaptSymbol(marketOrder.getCurrencyPair()), marketOrder.getType() == Order.OrderType.BID || marketOrder.getType() == Order.OrderType.EXIT_BID ? "3" : "4", "0", marketOrder.getOriginalAmount().toPlainString(), this.futuresContract, 1, this.leverRate).getOrderId();
        return String.valueOf(orderId);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        if (limitOrder.getType() == Order.OrderType.BID || limitOrder.getType() == Order.OrderType.ASK) {
            long orderId = this.futuresTrade(OkCoinAdapters.adaptSymbol(limitOrder.getCurrencyPair()), limitOrder.getType() == Order.OrderType.BID ? "1" : "2", limitOrder.getLimitPrice().toPlainString(), limitOrder.getOriginalAmount().toPlainString(), this.futuresContract, 0, this.leverRate).getOrderId();
            return String.valueOf(orderId);
        }
        return this.liquidateLimitOrder(limitOrder);
    }

    public String liquidateLimitOrder(LimitOrder limitOrder) throws IOException {
        long orderId = this.futuresTrade(OkCoinAdapters.adaptSymbol(limitOrder.getCurrencyPair()), limitOrder.getType() == Order.OrderType.BID || limitOrder.getType() == Order.OrderType.EXIT_BID ? "3" : "4", limitOrder.getLimitPrice().toPlainString(), limitOrder.getOriginalAmount().toPlainString(), this.futuresContract, 0, this.leverRate).getOrderId();
        return String.valueOf(orderId);
    }

    public boolean cancelOrder(String orderId) throws IOException {
        boolean ret = false;
        long id = Long.valueOf(orderId);
        List exchangeSymbols = this.exchange.getExchangeSymbols();
        List<FuturesContract> exchangeContracts = this.getExchangeContracts();
        block2: for (int i = 0; i < exchangeSymbols.size(); ++i) {
            CurrencyPair symbol = (CurrencyPair)exchangeSymbols.get(i);
            for (FuturesContract futuresContract : exchangeContracts) {
                try {
                    OkCoinTradeResult cancelResult = this.futuresCancelOrder(id, OkCoinAdapters.adaptSymbol(symbol), futuresContract);
                    if (id != cancelResult.getOrderId()) continue block2;
                    ret = true;
                    continue block2;
                }
                catch (ExchangeException e) {
                    if (!e.getMessage().equals(OkCoinUtils.getErrorMessage(1009)) && !e.getMessage().equals(OkCoinUtils.getErrorMessage(20015))) continue;
                }
            }
        }
        return ret;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        OkCoinFuturesTradeHistoryParams myParams = (OkCoinFuturesTradeHistoryParams)params;
        long orderId = myParams.getOrderId() != null ? Long.valueOf(myParams.getOrderId()) : -1L;
        CurrencyPair currencyPair = myParams.getCurrencyPair();
        String page = myParams.getPageNumber().toString();
        String pageLength = myParams.getPageLength().toString();
        FuturesContract reqFuturesContract = myParams.futuresContract;
        OkCoinFuturesTradeHistoryResult[] orderHistory = this.getFuturesTradesHistory(OkCoinAdapters.adaptSymbol(currencyPair), Long.valueOf("86751191"), "2015-12-04");
        return OkCoinAdapters.adaptTradeHistory(orderHistory);
    }

    public List<FuturesContract> getExchangeContracts() {
        return Arrays.asList(FuturesContract.values());
    }

    public OkCoinFuturesTradeHistoryParams createTradeHistoryParams() {
        return new OkCoinFuturesTradeHistoryParams(50, 0, CurrencyPair.BTC_USD, this.futuresContract, null);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        List exchangeSymbols = this.exchange.getExchangeSymbols();
        ArrayList<Order> openOrders = new ArrayList<Order>();
        ArrayList<OkCoinFuturesOrder> orderResults = new ArrayList<OkCoinFuturesOrder>(exchangeSymbols.size());
        ArrayList<String> orderIdsRequest = new ArrayList<String>();
        HashSet orderSet = new HashSet();
        Collections.addAll(orderSet, orderIds);
        for (int i = 0; i < exchangeSymbols.size(); ++i) {
            CurrencyPair symbol = (CurrencyPair)exchangeSymbols.get(i);
            this.log.debug("Getting order: {}", (Object)symbol);
            int count = 0;
            orderIdsRequest.clear();
            for (String order : orderSet) {
                orderIdsRequest.add(order);
                if (++count % 50 != 0) continue;
                OkCoinFuturesOrderResult orderResult = this.getFuturesOrders(this.createDelimitedString(orderIdsRequest.toArray(new String[orderIdsRequest.size()])), OkCoinAdapters.adaptSymbol(symbol), this.futuresContract);
                orderIdsRequest.clear();
                if (orderResult.getOrders().length <= 0) continue;
                orderResults.addAll(new ArrayList<OkCoinFuturesOrder>(Arrays.asList(orderResult.getOrders())));
            }
            OkCoinFuturesOrderResult orderResult = !orderIdsRequest.isEmpty() ? this.getFuturesOrders(this.createDelimitedString(orderIdsRequest.toArray(new String[orderIdsRequest.size()])), OkCoinAdapters.adaptSymbol(symbol), this.futuresContract) : this.getFuturesFilledOrder(-1L, OkCoinAdapters.adaptSymbol(symbol), "0", "50", this.futuresContract);
            if (orderResult.getOrders().length <= 0) continue;
            for (int o = 0; o < orderResult.getOrders().length; ++o) {
                OkCoinFuturesOrder singleOrder = orderResult.getOrders()[o];
                openOrders.add((Order)OkCoinAdapters.adaptOpenOrderFutures(singleOrder));
            }
        }
        return openOrders;
    }

    public static final class OkCoinFuturesTradeHistoryParams
    extends DefaultTradeHistoryParamPaging
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamFuturesContract {
        private CurrencyPair currencyPair;
        private FuturesContract futuresContract;
        private String orderId;

        public OkCoinFuturesTradeHistoryParams() {
        }

        public OkCoinFuturesTradeHistoryParams(Integer pageLength, Integer pageNumber, CurrencyPair currencyPair, FuturesContract futuresContract, String orderId) {
            super(pageLength, pageNumber);
            this.currencyPair = currencyPair;
            this.futuresContract = futuresContract;
            this.orderId = orderId;
        }

        public void setCurrencyPair(CurrencyPair pair) {
            this.currencyPair = pair;
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        @Override
        public FuturesContract getFuturesContract() {
            return this.futuresContract;
        }

        @Override
        public void setFuturesContract(FuturesContract futuresContract) {
            this.futuresContract = futuresContract;
        }

        @Override
        public String getOrderId() {
            return this.orderId;
        }

        @Override
        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }
    }

    public static interface TradeHistoryParamFuturesContract
    extends TradeHistoryParams {
        public FuturesContract getFuturesContract();

        public void setFuturesContract(FuturesContract var1);

        public String getOrderId();

        public void setOrderId(String var1);
    }
}

