/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.OkCoin;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinDepth;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTickerResponse;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTrade;
import org.knowm.xchange.okcoin.service.OkCoinBaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class OkCoinMarketDataServiceRaw
extends OkCoinBaseService {
    private final OkCoin okCoin;

    public OkCoinMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.okCoin = (OkCoin)RestProxyFactory.createProxy(OkCoin.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
    }

    public OkCoinTickerResponse getTicker(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getTicker("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public OkCoinTickerResponse getFuturesTicker(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesTicker(OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName());
    }

    public OkCoinDepth getDepth(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getDepth("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public OkCoinDepth getFuturesDepth(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesDepth("1", OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName().toLowerCase());
    }

    public OkCoinTrade[] getTrades(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getTrades("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public OkCoinTrade[] getTrades(CurrencyPair currencyPair, long since) throws IOException {
        return this.okCoin.getTrades("1", OkCoinAdapters.adaptSymbol(currencyPair), since);
    }

    public OkCoinTrade[] getFuturesTrades(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesTrades("1", OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName().toLowerCase());
    }
}

