/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.OkCoinUtils;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinTradeResult;
import org.knowm.xchange.okcoin.service.OkCoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkCoinTradeService
extends OkCoinTradeServiceRaw
implements TradeService {
    private static final OpenOrders noOpenOrders = new OpenOrders(Collections.emptyList());
    private final Logger log = LoggerFactory.getLogger(OkCoinTradeService.class);

    public OkCoinTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        List exchangeSymbols = this.exchange.getExchangeSymbols();
        ArrayList<OkCoinOrderResult> orderResults = new ArrayList<OkCoinOrderResult>(exchangeSymbols.size());
        for (int i = 0; i < exchangeSymbols.size(); ++i) {
            CurrencyPair symbol = (CurrencyPair)exchangeSymbols.get(i);
            this.log.debug("Getting order: {}", (Object)symbol);
            OkCoinOrderResult orderResult = this.getOrder(-1L, OkCoinAdapters.adaptSymbol(symbol));
            if (orderResult.getOrders().length <= 0) continue;
            orderResults.add(orderResult);
        }
        if (orderResults.size() <= 0) {
            return noOpenOrders;
        }
        return OkCoinAdapters.adaptOpenOrders(orderResults);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        String marketOrderType = null;
        String rate = null;
        String amount = null;
        if (marketOrder.getType().equals((Object)Order.OrderType.BID)) {
            marketOrderType = "buy_market";
            rate = marketOrder.getOriginalAmount().toPlainString();
            amount = "1";
        } else {
            marketOrderType = "sell_market";
            rate = "1";
            amount = marketOrder.getOriginalAmount().toPlainString();
        }
        long orderId = this.trade(OkCoinAdapters.adaptSymbol(marketOrder.getCurrencyPair()), marketOrderType, rate, amount).getOrderId();
        return String.valueOf(orderId);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        long orderId = this.trade(OkCoinAdapters.adaptSymbol(limitOrder.getCurrencyPair()), limitOrder.getType() == Order.OrderType.BID ? "buy" : "sell", limitOrder.getLimitPrice().toPlainString(), limitOrder.getOriginalAmount().toPlainString()).getOrderId();
        return String.valueOf(orderId);
    }

    public boolean cancelOrder(String orderId) throws IOException {
        boolean ret = false;
        long id = Long.valueOf(orderId);
        List exchangeSymbols = this.exchange.getExchangeSymbols();
        for (int i = 0; i < exchangeSymbols.size(); ++i) {
            CurrencyPair symbol = (CurrencyPair)exchangeSymbols.get(i);
            try {
                OkCoinTradeResult cancelResult = this.cancelOrder(id, OkCoinAdapters.adaptSymbol(symbol));
                if (id != cancelResult.getOrderId()) break;
                ret = true;
                break;
            }
            catch (ExchangeException e) {
                if (!e.getMessage().equals(OkCoinUtils.getErrorMessage(1009))) continue;
            }
        }
        return ret;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        TradeHistoryParamPaging paging = (TradeHistoryParamPaging)params;
        Integer pageLength = paging.getPageLength();
        Integer pageNumber = paging.getPageNumber();
        pageNumber = pageNumber + 1;
        CurrencyPair pair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        if (pair == null) {
            pair = this.useIntl ? CurrencyPair.BTC_USD : CurrencyPair.BTC_CNY;
        }
        OkCoinOrderResult orderHistory = this.getOrderHistory(OkCoinAdapters.adaptSymbol(pair), "1", OkCoinTradeService.toString(pageNumber), OkCoinTradeService.toString(pageLength));
        return OkCoinAdapters.adaptTrades(orderHistory);
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new OkCoinTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public static class OkCoinTradeHistoryParams
    extends DefaultTradeHistoryParamPaging
    implements TradeHistoryParamCurrencyPair {
        private CurrencyPair pair;

        public OkCoinTradeHistoryParams() {
        }

        public OkCoinTradeHistoryParams(Integer pageLength, Integer pageNumber, CurrencyPair pair) {
            super(pageLength, pageNumber);
            this.pair = pair;
        }

        public void setCurrencyPair(CurrencyPair pair) {
            this.pair = pair;
        }

        public CurrencyPair getCurrencyPair() {
            return this.pair;
        }
    }
}

