/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesTradeHistoryResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinPositionResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinTradeResult;
import org.knowm.xchange.okcoin.service.OKCoinBaseTradeService;

public class OkCoinTradeServiceRaw
extends OKCoinBaseTradeService {
    protected OkCoinTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public OkCoinTradeResult trade(String symbol, String type, String rate, String amount) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.trade(this.apikey, symbol, type, rate, amount, this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult cancelOrder(long orderId, String symbol) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.cancelOrder(this.apikey, orderId, symbol, this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinOrderResult getOrder(long orderId, String symbol) throws IOException {
        OkCoinOrderResult orderResult = this.okCoin.getOrder(this.apikey, orderId, symbol, this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(orderResult);
    }

    public OkCoinOrderResult getOrderHistory(String symbol, String status, String currentPage, String pageLength) throws IOException {
        OkCoinOrderResult orderResult = this.okCoin.getOrderHistory(this.apikey, symbol, status, currentPage, pageLength, this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(orderResult);
    }

    public OkCoinTradeResult futuresTrade(String symbol, String type, String price, String amount, FuturesContract contract, int matchPrice, int leverRate) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.futuresTrade(this.apikey, symbol, contract.getName(), type, price, amount, matchPrice, leverRate, this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult futuresCancelOrder(long orderId, String symbol, FuturesContract contract) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.futuresCancelOrder(this.apikey, orderId, symbol, contract.getName(), this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinFuturesOrderResult getFuturesOrder(long orderId, String symbol, String currentPage, String pageLength, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrder(this.apikey, orderId, symbol, "1", currentPage, pageLength, contract.getName(), this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinFuturesOrderResult getFuturesFilledOrder(long orderId, String symbol, String currentPage, String pageLength, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrder(this.apikey, orderId, symbol, "2", currentPage, pageLength, contract.getName(), this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinFuturesOrderResult getFuturesOrders(String orderIds, String symbol, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrders(this.apikey, orderIds, symbol, contract.getName(), this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinFuturesTradeHistoryResult[] getFuturesTradesHistory(String symbol, long since, String date) throws IOException {
        OkCoinFuturesTradeHistoryResult[] futuresHistory = this.okCoin.getFuturesTradeHistory(this.apikey, since, symbol, date, this.signatureCreator);
        return futuresHistory;
    }

    public OkCoinPositionResult getFuturesPosition(String symbol, FuturesContract contract) throws IOException {
        OkCoinPositionResult futuresPositionsCross = this.okCoin.getFuturesPositionsCross(this.apikey, symbol, contract.getName(), this.signatureCreator);
        return OkCoinTradeServiceRaw.returnOrThrow(futuresPositionsCross);
    }
}

