/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.paymium;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.paymium.dto.marketdata.PaymiumMarketDepth;
import org.knowm.xchange.paymium.dto.marketdata.PaymiumMarketOrder;
import org.knowm.xchange.paymium.dto.marketdata.PaymiumTicker;
import org.knowm.xchange.paymium.dto.marketdata.PaymiumTrade;

public class PaymiumAdapters {
    private PaymiumAdapters() {
    }

    public static Ticker adaptTicker(PaymiumTicker PaymiumTicker2, CurrencyPair currencyPair) {
        BigDecimal bid = PaymiumTicker2.getBid();
        BigDecimal ask = PaymiumTicker2.getAsk();
        BigDecimal high = PaymiumTicker2.getHigh();
        BigDecimal low = PaymiumTicker2.getLow();
        BigDecimal last = PaymiumTicker2.getPrice();
        BigDecimal volume = PaymiumTicker2.getVolume();
        Date timestamp = new Date(PaymiumTicker2.getAt() * 1000L);
        return new Ticker.Builder().currencyPair(currencyPair).bid(bid).ask(ask).high(high).low(low).last(last).volume(volume).timestamp(timestamp).build();
    }

    public static OrderBook adaptMarketDepth(PaymiumMarketDepth marketDepth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = PaymiumAdapters.adaptMarketOrderToLimitOrder(marketDepth.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = PaymiumAdapters.adaptMarketOrderToLimitOrder(marketDepth.getBids(), Order.OrderType.BID, currencyPair);
        Collections.reverse(bids);
        return new OrderBook(null, asks, bids);
    }

    private static List<LimitOrder> adaptMarketOrderToLimitOrder(List<PaymiumMarketOrder> PaymiumMarketOrders, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>(PaymiumMarketOrders.size());
        for (PaymiumMarketOrder PaymiumMarketOrder2 : PaymiumMarketOrders) {
            LimitOrder limitOrder = new LimitOrder(orderType, PaymiumMarketOrder2.getAmount(), currencyPair, null, new Date(PaymiumMarketOrder2.getTimestamp()), PaymiumMarketOrder2.getPrice());
            orders.add(limitOrder);
        }
        return orders;
    }

    public static Trades adaptTrade(PaymiumTrade[] PaymiumTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (PaymiumTrade PaymiumTrade2 : PaymiumTrades) {
            Trade trade = new Trade(null, PaymiumTrade2.getTraded_btc(), currencyPair, PaymiumTrade2.getPrice(), new Date(PaymiumTrade2.getCreated_at_int()), PaymiumTrade2.getUuid().toString());
            trades.add(trade);
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }
}

