/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.quoine.Quoine;
import org.knowm.xchange.quoine.dto.account.BitcoinAccount;
import org.knowm.xchange.quoine.dto.account.FiatAccount;
import org.knowm.xchange.quoine.dto.account.QuoineAccountBalance;
import org.knowm.xchange.quoine.dto.account.QuoineTradingAccountInfo;
import org.knowm.xchange.quoine.dto.trade.QuoineExecutionsResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineNewOrderRequestWrapper;
import org.knowm.xchange.quoine.dto.trade.QuoineOrderDetailsResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineOrderResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineOrdersList;
import org.knowm.xchange.quoine.dto.trade.QuoineTradesResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineTransactionsResponse;
import si.mazi.rescu.ParamsDigest;

@Path(value="/")
@Produces(value={"application/json"})
public interface QuoineAuthenticated
extends Quoine {
    @GET
    @Path(value="fiat_accounts")
    public FiatAccount[] getFiatAccountInfo(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3) throws IOException;

    @GET
    @Path(value="crypto_accounts")
    public BitcoinAccount[] getCryptoAccountInfo(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3) throws IOException;

    @GET
    @Path(value="accounts/balance")
    public QuoineAccountBalance[] getAllBalance(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3) throws IOException;

    @GET
    @Path(value="trading_accounts")
    public QuoineTradingAccountInfo[] getTradingAccountInfo(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3) throws IOException;

    @POST
    @Path(value="orders/")
    @Consumes(value={"application/json"})
    public QuoineOrderResponse placeOrder(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, QuoineNewOrderRequestWrapper var4) throws IOException;

    @PUT
    @Path(value="orders/{order_id}/cancel")
    public QuoineOrderResponse cancelOrder(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, @PathParam(value="order_id") String var4) throws IOException;

    @GET
    @Path(value="orders/{order_id}")
    public QuoineOrderDetailsResponse orderDetails(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, @PathParam(value="order_id") String var4) throws IOException;

    @GET
    @Path(value="orders")
    public QuoineOrdersList listOrders(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3) throws IOException;

    @GET
    @Path(value="executions/me")
    public QuoineExecutionsResponse executions(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, @QueryParam(value="product_id") int var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="page") Integer var6, @QueryParam(value="with_details") int var7) throws IOException;

    @GET
    @Path(value="trades")
    public QuoineTradesResponse trades(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, @QueryParam(value="funding_currency") String var4, @QueryParam(value="status") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="page") Integer var7) throws IOException;

    @GET
    @Path(value="transactions")
    public QuoineTransactionsResponse transactions(@HeaderParam(value="X-Quoine-API-Version") int var1, @HeaderParam(value="X-Quoine-Auth") ParamsDigest var2, @HeaderParam(value="Content-Type") String var3, @QueryParam(value="currency") String var4, @QueryParam(value="transaction_type") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="page") Integer var7) throws IOException;
}

