/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.quoine.QuoineAdapters;
import org.knowm.xchange.quoine.dto.account.BitcoinAccount;
import org.knowm.xchange.quoine.dto.account.FiatAccount;
import org.knowm.xchange.quoine.dto.trade.QuoineTransaction;
import org.knowm.xchange.quoine.service.QuoineAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class QuoineAccountService
extends QuoineAccountServiceRaw
implements AccountService {
    private final boolean useMargin;

    public QuoineAccountService(BaseExchange baseExchange, boolean useMargin) {
        super((Exchange)baseExchange);
        this.useMargin = useMargin;
    }

    public AccountInfo getAccountInfo() throws IOException {
        FiatAccount[] quoineFiatAccountInfo = this.getQuoineFiatAccountInfo();
        List<Wallet> fiatBalances = QuoineAdapters.adapt(quoineFiatAccountInfo);
        BitcoinAccount[] cyptoBalances = this.getQuoineCryptoAccountInfo();
        List<Wallet> cryptoWallets = QuoineAdapters.adapt(cyptoBalances);
        ArrayList<Wallet> all = new ArrayList<Wallet>();
        all.addAll(fiatBalances);
        all.addAll(cryptoWallets);
        return new AccountInfo(all);
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        BitcoinAccount[] quoineCryptoAccountInfo;
        for (BitcoinAccount bitcoinAccount : quoineCryptoAccountInfo = this.getQuoineCryptoAccountInfo()) {
            Currency ccy = Currency.getInstance((String)bitcoinAccount.getCurrency());
            if (!ccy.equals((Object)currency)) continue;
            return bitcoinAccount.getAddress();
        }
        return null;
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        Integer page = 1;
        Integer limit = null;
        Currency currency = null;
        if (params instanceof TradeHistoryParamCurrency) {
            currency = ((TradeHistoryParamCurrency)params).getCurrency();
        }
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging tradeHistoryParamPaging = (TradeHistoryParamPaging)params;
            page = tradeHistoryParamPaging.getPageNumber();
            limit = tradeHistoryParamPaging.getPageLength();
        }
        ArrayList<FundingRecord> res = new ArrayList<FundingRecord>();
        for (QuoineTransaction transaction : this.depositHistory(currency, limit, page)) {
            res.add(QuoineAdapters.adaptFunding(currency, transaction, FundingRecord.Type.DEPOSIT));
        }
        for (QuoineTransaction transaction : this.withdrawalHistory(currency, limit, page)) {
            res.add(QuoineAdapters.adaptFunding(currency, transaction, FundingRecord.Type.WITHDRAWAL));
        }
        return res;
    }

    public static class QuoineFundingHistoryParam
    implements TradeHistoryParamCurrency,
    TradeHistoryParamPaging {
        private Currency currency;
        private Integer pageLength;
        private Integer pageNumber;

        public QuoineFundingHistoryParam(Currency currency, Integer pageLength, Integer pageNumber) {
            this.currency = currency;
            this.pageLength = pageLength;
            this.pageNumber = pageNumber;
        }

        public QuoineFundingHistoryParam() {
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public void setPageLength(Integer pageLength) {
            this.pageLength = pageLength;
        }

        public Integer getPageLength() {
            return this.pageLength;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }
    }
}

