/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.quoine.dto.account.BitcoinAccount;
import org.knowm.xchange.quoine.dto.account.FiatAccount;
import org.knowm.xchange.quoine.dto.account.QuoineAccountBalance;
import org.knowm.xchange.quoine.dto.account.QuoineTradingAccountInfo;
import org.knowm.xchange.quoine.dto.trade.QuoineTransaction;
import org.knowm.xchange.quoine.dto.trade.QuoineTransactionsResponse;
import org.knowm.xchange.quoine.service.QuoineBaseService;
import org.knowm.xchange.utils.Assert;
import si.mazi.rescu.HttpStatusIOException;

public class QuoineAccountServiceRaw
extends QuoineBaseService {
    protected QuoineAccountServiceRaw(Exchange exchange) {
        super(exchange);
        Assert.notNull((Object)exchange.getExchangeSpecification().getSslUri(), (String)"Exchange specification URI cannot be null");
    }

    public FiatAccount[] getQuoineFiatAccountInfo() throws IOException {
        try {
            return this.quoine.getFiatAccountInfo(2, this.signatureCreator, "application/json");
        }
        catch (HttpStatusIOException e) {
            throw new ExchangeException(e.getHttpBody(), (Throwable)e);
        }
    }

    public BitcoinAccount[] getQuoineCryptoAccountInfo() throws IOException {
        try {
            return this.quoine.getCryptoAccountInfo(2, this.signatureCreator, "application/json");
        }
        catch (HttpStatusIOException e) {
            throw new ExchangeException(e.getHttpBody(), (Throwable)e);
        }
    }

    public QuoineTradingAccountInfo[] getQuoineTradingAccountInfo() throws IOException {
        try {
            return this.quoine.getTradingAccountInfo(2, this.signatureCreator, "application/json");
        }
        catch (HttpStatusIOException e) {
            throw new ExchangeException(e.getHttpBody(), (Throwable)e);
        }
    }

    public QuoineAccountBalance[] getQuoineAccountBalance() throws IOException {
        try {
            return this.quoine.getAllBalance(2, this.signatureCreator, "application/json");
        }
        catch (HttpStatusIOException e) {
            throw new ExchangeException(e.getHttpBody(), (Throwable)e);
        }
    }

    public List<QuoineTransaction> depositHistory(Currency currency, Integer limit, Integer page) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        QuoineTransactionsResponse response = this.quoine.transactions(2, this.signatureCreator, "application/json", currency.getCurrencyCode(), "funding", limit, page);
        return response.models;
    }

    public List<QuoineTransaction> withdrawalHistory(Currency currency, Integer limit, Integer page) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        QuoineTransactionsResponse response = this.quoine.transactions(2, this.signatureCreator, "application/json", currency.getCurrencyCode(), "withdrawal", limit, page);
        return response.models;
    }
}

