/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.quoine.dto.trade.QuoineExecution;
import org.knowm.xchange.quoine.dto.trade.QuoineExecutionsResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineNewMarginOrderRequest;
import org.knowm.xchange.quoine.dto.trade.QuoineNewOrderRequest;
import org.knowm.xchange.quoine.dto.trade.QuoineNewOrderRequestWrapper;
import org.knowm.xchange.quoine.dto.trade.QuoineOrderDetailsResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineOrderResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineOrdersList;
import org.knowm.xchange.quoine.dto.trade.QuoineTradesResponse;
import org.knowm.xchange.quoine.dto.trade.QuoineTransaction;
import org.knowm.xchange.quoine.dto.trade.QuoineTransactionsResponse;
import org.knowm.xchange.quoine.service.QuoineBaseService;
import org.knowm.xchange.quoine.service.QuoineTrade;
import si.mazi.rescu.HttpStatusIOException;

public class QuoineTradeServiceRaw
extends QuoineBaseService {
    private boolean useMargin;
    private int leverageLevel;

    public QuoineTradeServiceRaw(Exchange exchange, boolean useMargin) {
        super(exchange);
        this.useMargin = useMargin;
        this.leverageLevel = useMargin ? Integer.valueOf((String)exchange.getExchangeSpecification().getExchangeSpecificParametersItem("Leverage_Level")) : 0;
    }

    public QuoineOrderResponse placeLimitOrder(CurrencyPair currencyPair, String type, BigDecimal originalAmount, BigDecimal price) throws IOException {
        int productId = this.productId(currencyPair);
        QuoineNewOrderRequest quoineNewOrderRequest = this.useMargin ? new QuoineNewMarginOrderRequest("limit", productId, type, originalAmount, price, this.leverageLevel, currencyPair.counter.getCurrencyCode()) : new QuoineNewOrderRequest("limit", productId, type, originalAmount, price);
        try {
            return this.quoine.placeOrder(2, this.signatureCreator, "application/json", new QuoineNewOrderRequestWrapper(quoineNewOrderRequest));
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public QuoineOrderResponse placeMarketOrder(CurrencyPair currencyPair, String type, BigDecimal originalAmount) throws IOException {
        int productId = this.productId(currencyPair);
        QuoineNewOrderRequest quoineNewOrderRequest = this.useMargin ? new QuoineNewMarginOrderRequest("market", productId, type, originalAmount, null, this.leverageLevel, currencyPair.counter.getCurrencyCode()) : new QuoineNewOrderRequest("market", productId, type, originalAmount, null);
        try {
            return this.quoine.placeOrder(2, this.signatureCreator, "application/json", new QuoineNewOrderRequestWrapper(quoineNewOrderRequest));
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public QuoineOrderResponse cancelQuoineOrder(String orderID) throws IOException {
        try {
            return this.quoine.cancelOrder(2, this.signatureCreator, "application/json", orderID);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public QuoineOrderDetailsResponse getQuoineOrderDetails(String orderID) throws IOException {
        try {
            return this.quoine.orderDetails(2, this.signatureCreator, "application/json", orderID);
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public QuoineOrdersList listQuoineOrders() throws IOException {
        try {
            return this.quoine.listOrders(2, this.signatureCreator, "application/json");
        }
        catch (HttpStatusIOException e) {
            throw this.handleHttpError(e);
        }
    }

    public List<QuoineExecution> executions(CurrencyPair currencyPair, Integer limit, Integer page) throws IOException {
        int productId = this.productId(currencyPair);
        QuoineExecutionsResponse response = this.quoine.executions(2, this.signatureCreator, "application/json", productId, limit, page, 1);
        return response.models;
    }

    public List<QuoineTrade> trades(Currency fundingCurrency, Integer limit, Integer page) throws IOException {
        QuoineTradesResponse response = this.quoine.trades(2, this.signatureCreator, "application/json", fundingCurrency == null ? null : fundingCurrency.getCurrencyCode(), "null", limit, page);
        return response.models;
    }

    public List<QuoineTransaction> transactions(Currency currency, Integer limit, Integer page) throws IOException {
        QuoineTransactionsResponse transactions = this.quoine.transactions(2, this.signatureCreator, "application/json", currency == null ? null : currency.getCurrencyCode(), null, limit, page);
        return transactions.models;
    }
}

