/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.io.IOException;
import java.util.HashMap;
import javax.persistence.spi.PersistenceUnitInfo;
import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.JpaPersistenceDatabase;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class HibernateSpringPackageDatabase
extends JpaPersistenceDatabase {
    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:spring:") && !this.isXmlFile(conn);
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 10;
    }

    protected boolean isXmlFile(DatabaseConnection connection) {
        HibernateConnection hibernateConnection;
        if (connection instanceof JdbcConnection) {
            hibernateConnection = (HibernateConnection)((JdbcConnection)connection).getUnderlyingConnection();
        } else if (connection instanceof HibernateConnection) {
            hibernateConnection = (HibernateConnection)connection;
        } else {
            return false;
        }
        String path = hibernateConnection.getPath();
        if (path.contains("/")) {
            return true;
        }
        ClassPathResource resource = new ClassPathResource(path);
        try {
            return resource.exists() && !resource.getFile().isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected EntityManagerFactoryBuilderImpl createEntityManagerFactoryBuilder() {
        String[] packagesToScan;
        DefaultPersistenceUnitManager internalPersistenceUnitManager = new DefaultPersistenceUnitManager();
        internalPersistenceUnitManager.setResourceLoader((ResourceLoader)new DefaultResourceLoader(Scope.getCurrentScope().getClassLoader()));
        for (String packageName : packagesToScan = this.getHibernateConnection().getPath().split(",")) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Found package " + packageName);
        }
        internalPersistenceUnitManager.setPackagesToScan(packagesToScan);
        internalPersistenceUnitManager.preparePersistenceUnitInfos();
        PersistenceUnitInfo persistenceUnitInfo = internalPersistenceUnitManager.obtainDefaultPersistenceUnitInfo();
        HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
        if (persistenceUnitInfo instanceof SmartPersistenceUnitInfo) {
            ((SmartPersistenceUnitInfo)persistenceUnitInfo).setPersistenceProviderPackageName(jpaVendorAdapter.getPersistenceProviderRootPackage());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", this.getProperty("hibernate.dialect"));
        map.put("hibernate.cache.use_second_level_cache", Boolean.FALSE.toString());
        map.put("hibernate.physical_naming_strategy", this.getHibernateConnection().getProperties().getProperty("hibernate.physical_naming_strategy"));
        map.put("hibernate.implicit_naming_strategy", this.getHibernateConnection().getProperties().getProperty("hibernate.implicit_naming_strategy"));
        map.put("hibernate.archive.autodetection", "");
        map.put("org.hibernate.envers.audit_table_prefix", this.getHibernateConnection().getProperties().getProperty("org.hibernate.envers.audit_table_prefix", ""));
        map.put("org.hibernate.envers.audit_table_suffix", this.getHibernateConnection().getProperties().getProperty("org.hibernate.envers.audit_table_suffix", "_AUD"));
        map.put("hibernate.use_nationalized_character_data", this.getProperty("hibernate.use_nationalized_character_data"));
        EntityManagerFactoryBuilderImpl builder = (EntityManagerFactoryBuilderImpl)Bootstrap.getEntityManagerFactoryBuilder(persistenceUnitInfo, map);
        return builder;
    }

    @Override
    public String getShortName() {
        return "hibernateSpringPackage";
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Hibernate Spring Package";
    }
}

