/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Collection;
import java.util.Iterator;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class ForeignKeySnapshotGenerator
extends HibernateSnapshotGenerator {
    public ForeignKeySnapshotGenerator() {
        super(ForeignKey.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(ForeignKey.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            MetadataImplementor metadata = (MetadataImplementor)database.getMetadata();
            Collection<Table> tmapp = metadata.collectTableMappings();
            for (Table hibernateTable : tmapp) {
                Iterator<org.hibernate.mapping.ForeignKey> fkIterator = hibernateTable.getForeignKeyIterator();
                while (fkIterator.hasNext()) {
                    org.hibernate.mapping.ForeignKey hibernateForeignKey = fkIterator.next();
                    liquibase.structure.core.Table currentTable = new liquibase.structure.core.Table().setName(hibernateTable.getName());
                    currentTable.setSchema(hibernateTable.getCatalog(), hibernateTable.getSchema());
                    Table hibernateReferencedTable = hibernateForeignKey.getReferencedTable();
                    liquibase.structure.core.Table referencedTable = new liquibase.structure.core.Table().setName(hibernateReferencedTable.getName());
                    referencedTable.setSchema(hibernateReferencedTable.getCatalog(), hibernateReferencedTable.getSchema());
                    if (!hibernateForeignKey.isCreationEnabled() || !hibernateForeignKey.isPhysicalConstraint()) continue;
                    ForeignKey fk = new ForeignKey();
                    fk.setName(hibernateForeignKey.getName());
                    fk.setPrimaryKeyTable(referencedTable);
                    fk.setForeignKeyTable(currentTable);
                    for (Column column : hibernateForeignKey.getColumns()) {
                        fk.addForeignKeyColumn(new liquibase.structure.core.Column(column.getName()));
                    }
                    for (Column column : hibernateForeignKey.getReferencedColumns()) {
                        fk.addPrimaryKeyColumn(new liquibase.structure.core.Column(column.getName()));
                    }
                    if (fk.getPrimaryKeyColumns() == null || fk.getPrimaryKeyColumns().isEmpty()) {
                        for (Column column : hibernateReferencedTable.getPrimaryKey().getColumns()) {
                            fk.addPrimaryKeyColumn(new liquibase.structure.core.Column(column.getName()));
                        }
                    }
                    fk.setDeferrable(false);
                    fk.setInitiallyDeferred(false);
                    if (!DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)currentTable, (DatabaseObject)table, null, (Database)database)) continue;
                    table.getOutgoingForeignKeys().add(fk);
                    table.getSchema().addDatabaseObject((DatabaseObject)fk);
                }
            }
        }
    }
}

