/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.revisioninfo;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.envers.EntityTrackingRevisionListener;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;

public class DefaultRevisionInfoGenerator
implements RevisionInfoGenerator {
    private final String revisionInfoEntityName;
    private final ManagedBean<? extends RevisionListener> listenerManagedBean;
    private final Setter revisionTimestampSetter;
    private final boolean timestampAsDate;
    private final Constructor<?> revisionInfoClassConstructor;
    private final SessionCacheCleaner sessionCacheCleaner;
    private RevisionInfoNumberReader revisionInfoNumberReader;

    public DefaultRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, PropertyData revisionInfoTimestampData, boolean timestampAsDate, ServiceRegistry serviceRegistry) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.timestampAsDate = timestampAsDate;
        this.revisionInfoClassConstructor = ReflectHelper.getDefaultConstructor(revisionInfoClass);
        this.revisionTimestampSetter = ReflectionTools.getSetter(revisionInfoClass, revisionInfoTimestampData, serviceRegistry);
        this.listenerManagedBean = this.resolveRevisionListenerBean(listenerClass, serviceRegistry);
        this.sessionCacheCleaner = new SessionCacheCleaner();
    }

    @Override
    public void setRevisionInfoNumberReader(RevisionInfoNumberReader revisionInfoNumberReader) {
        this.revisionInfoNumberReader = revisionInfoNumberReader;
    }

    @Override
    public void saveRevisionData(Session session, Object revisionData) {
        session.save(this.revisionInfoEntityName, revisionData);
        if (this.revisionInfoNumberReader != null && this.revisionInfoNumberReader.getRevisionNumber(revisionData).longValue() < 0L) {
            throw new AuditException("Negative revision numbers are not allowed");
        }
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, revisionData);
    }

    @Override
    public Object generate() {
        Object revisionInfo;
        try {
            revisionInfo = this.revisionInfoClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timestamp = System.currentTimeMillis();
        this.revisionTimestampSetter.set(revisionInfo, this.timestampAsDate ? new Date(timestamp) : Long.valueOf(timestamp), null);
        if (this.listenerManagedBean != null) {
            this.listenerManagedBean.getBeanInstance().newRevision(revisionInfo);
        }
        return revisionInfo;
    }

    @Override
    public void entityChanged(Class entityClass, String entityName, Serializable entityId, RevisionType revisionType, Object revisionInfo) {
        RevisionListener listener;
        if (this.listenerManagedBean != null && EntityTrackingRevisionListener.class.isInstance(listener = this.listenerManagedBean.getBeanInstance())) {
            ((EntityTrackingRevisionListener)listener).entityChanged(entityClass, entityName, entityId, revisionType, revisionInfo);
        }
    }

    private ManagedBean<? extends RevisionListener> resolveRevisionListenerBean(Class<? extends RevisionListener> listenerClass, ServiceRegistry serviceRegistry) {
        if (!listenerClass.equals(RevisionListener.class)) {
            return serviceRegistry.getService(ManagedBeanRegistry.class).getBean(listenerClass);
        }
        return null;
    }
}

