/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.enabletrigger;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.enabletrigger.EnableTriggerStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableTriggerGenerator
extends AbstractSqlGenerator<EnableTriggerStatement> {
    public boolean supports(EnableTriggerStatement enableTriggertStatement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("triggerName", (Object)enableTriggerStatement.getTriggerName());
        return validationErrors;
    }

    public Sql[] generateSql(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TRIGGER ");
        if (enableTriggerStatement.getSchemaName() != null) {
            sql.append(enableTriggerStatement.getSchemaName()).append(".");
        }
        if (enableTriggerStatement.getTriggerName() == null) {
            throw new IllegalStateException("Sorry but triggerName must be set");
        }
        sql.append(enableTriggerStatement.getTriggerName()).append(" ");
        sql.append("ENABLE");
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

