/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.cdi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.cdi.CDILiquibaseConfig;
import liquibase.integration.cdi.annotations.LiquibaseType;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.LiquibaseUtil;
import liquibase.util.NetUtil;

@ApplicationScoped
public class CDILiquibase
implements Extension {
    @Inject
    @LiquibaseType
    ResourceAccessor resourceAccessor;
    @Inject
    @LiquibaseType
    protected CDILiquibaseConfig config;
    @Inject
    @LiquibaseType
    private DataSource dataSource;
    private boolean initialized;
    private boolean updateSuccessful;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isUpdateSuccessful() {
        return this.updateSuccessful;
    }

    @PostConstruct
    public void onStartup() {
        try {
            String hostName;
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            log.info("Booting Liquibase " + LiquibaseUtil.getBuildVersionInfo());
            try {
                hostName = NetUtil.getLocalHostName();
            }
            catch (Exception e) {
                log.warning("Cannot find hostname: " + e.getMessage());
                log.fine("", (Throwable)e);
                return;
            }
            if (!((Boolean)LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue()).booleanValue()) {
                log.info(String.format("Liquibase did not run on %s because %s was set to false.", hostName, LiquibaseCommandLineConfiguration.SHOULD_RUN.getKey()));
                return;
            }
            if (!this.config.getShouldRun()) {
                log.info(String.format("Liquibase did not run on %s because CDILiquibaseConfig.shouldRun was set to false.", hostName));
                return;
            }
            this.initialized = true;
            this.performUpdate();
        }
        catch (Throwable e) {
            Scope.getCurrentScope().getLog(this.getClass()).severe(e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected void performUpdate() throws LiquibaseException {
        Connection c = null;
        Liquibase liquibase = null;
        try {
            c = this.dataSource.getConnection();
            liquibase = this.createLiquibase(c);
            liquibase.update(new Contexts(this.config.getContexts()), new LabelExpression(this.config.getLabels()));
            this.updateSuccessful = true;
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (LiquibaseException ex) {
            this.updateSuccessful = false;
            throw ex;
        }
        finally {
            if (liquibase != null && liquibase.getDatabase() != null) {
                liquibase.getDatabase().close();
            } else if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.config.getChangeLog(), this.resourceAccessor, this.createDatabase(c));
        if (this.config.getParameters() != null) {
            for (Map.Entry<String, String> entry : this.config.getParameters().entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.config.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (this.config.getDefaultSchema() != null) {
            database.setDefaultSchemaName(this.config.getDefaultSchema());
        }
        return database;
    }
}

