/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import org.apache.maven.plugin.logging.Log;

public class MavenLog
implements Log {
    private final Log actualLog;
    private final Level level;

    public MavenLog(Log actualLog, Level level) {
        this.actualLog = actualLog;
        this.level = level;
    }

    public MavenLog(Log actualLog, String level) {
        this(actualLog, Level.valueOf(level));
    }

    public boolean isDebugEnabled() {
        return this.level.isAtLeast(Level.DEBUG) && this.actualLog.isDebugEnabled();
    }

    public void debug(CharSequence charSequence) {
        if (this.isDebugEnabled()) {
            this.actualLog.debug(charSequence);
        }
    }

    public void debug(CharSequence charSequence, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.actualLog.debug(charSequence, throwable);
        }
    }

    public void debug(Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.actualLog.debug(throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.level.isAtLeast(Level.INFO) && this.actualLog.isInfoEnabled();
    }

    public void info(CharSequence charSequence) {
        if (this.isInfoEnabled()) {
            this.actualLog.info(charSequence);
        }
    }

    public void info(CharSequence charSequence, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.actualLog.info(charSequence, throwable);
        }
    }

    public void info(Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.actualLog.info(throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.level.isAtLeast(Level.WARNING) && this.actualLog.isWarnEnabled();
    }

    public void warn(CharSequence charSequence) {
        if (this.isWarnEnabled()) {
            this.actualLog.warn(charSequence);
        }
    }

    public void warn(CharSequence charSequence, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.actualLog.warn(charSequence, throwable);
        }
    }

    public void warn(Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.actualLog.warn(throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.level.isAtLeast(Level.ERROR) && this.actualLog.isErrorEnabled();
    }

    public void error(CharSequence charSequence) {
        if (this.isErrorEnabled()) {
            this.actualLog.error(charSequence);
        }
    }

    public void error(CharSequence charSequence, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.actualLog.error(charSequence, throwable);
        }
    }

    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.actualLog.error(throwable);
        }
    }

    public static enum Level {
        DEBUG(0),
        debug(0),
        FINE(0),
        fine(0),
        INFO(1),
        info(1),
        WARNING(2),
        warning(2),
        ERROR(3),
        error(3);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean isAtLeast(Level other) {
            return this.level <= other.level;
        }
    }
}

